<?php

namespace  Vankineaddons\Core\Widgets\Post;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Blog_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-blog-v1';
    }

    public function get_title()
    {
        return __('Blog Post  V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['102'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('blog_settings',
        [ 
            'label' => __('Blog Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );


        $this->add_control(
            'blog_style',
            [
                'label' => __('Blog style', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one'   => esc_html__( 'Style One', 'vankine-addons' ),
                    'style_two'   => esc_html__( 'Style Two', 'vankine-addons' ),
                    'style_three'   => esc_html__( 'Style Three', 'vankine-addons' ), 
                    'style_four'   => esc_html__( 'Style Four', 'vankine-addons' ), 
                    'style_five'   => esc_html__( 'Style Five', 'vankine-addons' ), 
                ],
                'default' => 'style_one',
            ]
        );
  
        $this->add_control(
            'blog_column',
            [
                'label' => __('Blog Column', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'col-xl-3 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Four Column', 'vankine-addons' ),
                    'col-xl-4 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Three Column', 'vankine-addons' ),
                    'col-xl-6 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Two Column', 'vankine-addons' ),
                    'col-xl-12'   => esc_html__( 'One Column', 'vankine-addons' ),
                ],
                'default' => 'col-xl-3 col-lg-4 col-md-6 col-sm-6',
            
            ]
        );
        $this->add_control(
            'read_more',
            [
                'label' => __( 'Read More', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Read More', 'vankine-addons' ),
            ]
        );
        $this->add_control(
            'borerradisable',
           [
              'label' => __('Border Radius Enable / Disable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
               'condition' => [
                'blog_style' => 'style_one'
                ],
           ]
        );
        $this->add_control(
            'activeenable',
           [
              'label' => __('Hover Active Enable / Disable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
               'condition' => [
                'blog_style' => 'style_four'
                ],
           ]
        );

        $this->add_control(
            'post_count',
            [
                'label' => __('Blog Count', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 15,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
       
        $this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
                    ''       => esc_html__( 'Select', 'vankine-addons' ),
					'date'       => esc_html__( 'Date', 'vankine-addons' ),
					'title'      => esc_html__( 'Title', 'vankine-addons' ),
					'menu_order' => esc_html__( 'Menu Order', 'vankine-addons' ),
					'rand'       => esc_html__( 'Random', 'vankine-addons' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
                    ''       => esc_html__( 'Select', 'vankine-addons' ),
					'DESC' => esc_html__( 'DESC', 'vankine-addons' ),
					'ASC'  => esc_html__( 'ASC', 'vankine-addons' ),
				),
			]
        );
      
        $this->add_control(
            'query_category', 
			[
            'type' => \Elementor\Controls_Manager::SELECT,
			'label' => esc_html__('Category', 'vankine-addons'),
			'options' => vankine_get_blog_categories(),
			]
        );

        $this->add_control(
            'excerpt_enable',
           [
              'label' => __('Excerpt  Enable / Disable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );


        $this->add_control(
            'ajax_loadmore',
           [
              'label' => __('Ajax Load More Enable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
        $this->add_control(
            'load_more',
            [
                'label' => __( 'Load More', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Load More', 'vankine-addons' ),
                'condition' => [
                    'ajax_loadmore' => 'yes'
               ],
            ]
        );
        
        $this->add_control(
            'pagination_enable',
           [
              'label' => __('Pagination Enable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );
    
        $this->add_responsive_control(
            'pagination_alignment',
            [
                'label' => __('Pagination alignments', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                  'left' => [
                    'title' => __( 'Pagination Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                  ],
                  'center' => [
                    'title' => __( 'Pagination Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                  ],
                  'right' => [
                    'title' => __( 'Pagination Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                  ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                  '{{WRAPPER}} .pagination_blog ' => 'text-align: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes'
               ],
            ]
        );


        $this->add_control(
			'hrp',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'pagination_enable' => 'yes'
                ],
			]
		);

        $this->add_control(
            'pagcolor',
            [
                'label' => __('Pagination Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li a.page-link , {{WRAPPER}}   .pagination li .page-numbers , {{WRAPPER}}  .page-numbers li a.page-link , {{WRAPPER}}  .page-numbers li .page-numbers  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagacolor',
            [
                'label' => __('Pagination Active Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .pagination li span.current , {{WRAPPER}}  .page-numbers li span.current , {{WRAPPER}}  .pagination li span:hover , {{WRAPPER}}  .page-numbers li span:hover ' => 'color: {{VALUE}}!important; text-decoration-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagnxticoncolor',
            [
                'label' => __('Pagination Next / Prev  Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagnxtpreviconcolor',
            [
                'label' => __('Pagination Next / Prev Border Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'pagnxtbgcolor',
            [
                'label' => __('Pagination Next / Prev Bg Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'pagination_enable' => 'yes',
                ]
            ]
        );

       

        $this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
			]
		);
           
        $this->add_control(
            'load_more_color',
            [
                'label' => __('Load More Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
      

        $this->add_control(
            'load_moreborder_color',
            [
                'label' => __('Load More  Border Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn  ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );

            $this->add_control(
            'bgh1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
                ]
            );

           
            $this->add_group_control( 
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'btn_color_hover',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .pagination .theme_btn  ',
                    'condition' => [
                        'ajax_loadmore' => 'yes',
                    ]
                ]
            );
            $this->add_control(
                'bgh2',
                    [
                    'type' => \Elementor\Controls_Manager::DIVIDER, 
                    'condition' => [
                        'ajax_loadmore' => 'yes',
                    ]
                ]
            );
        $this->add_control(
            'load_ho_more_color',
            [
                'label' => __('Load More Hover Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'loadho_moreborder_color',
            [
                'label' => __('Load More Hover Border Color', 'vankine-addons'),
                'type' =>  \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'bgh1s',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                'condition' => [
                    'ajax_loadmore' => 'yes',
                ]
                ]
            );

           
            $this->add_group_control( 
                \Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'loadho_morebg_color',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .pagination .theme_btn:hover  ',
                    'condition' => [
                        'ajax_loadmore' => 'yes',
                    ]
                ]
            );
            $this->add_control(
                'bgh2s',
                    [
                    'type' => \Elementor\Controls_Manager::DIVIDER, 
                    'condition' => [
                        'ajax_loadmore' => 'yes',
                    ]
                ]
            );
    
        $this->end_controls_section();
        $this->start_controls_section('custom_css',
        [ 
            'label' => __('Custom Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
        );
        $this->add_control(
            'bg_color',
             [
                'label' => __('Background Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_one .blog_inner , {{WRAPPER}} .blog_box.type_two ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => ['style_one' , 'style_two' , 'style_three'] ,
               ],
             ]
        );
        $this->add_control(
            'bgt_color',
             [
                'label' => __('Background Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_two.type_four.hover_1 .oh ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => 'style_four',
               ],
             ]
        );
        $this->add_control(
            'overlay_color',
             [
                'label' => __('Hover Overlay Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box .hover_1 .oh   ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => ['style_one' , 'style_two' , 'style_three' , 'style_five'] ,
               ],
             ]
        );
        $this->add_control(
            'overlayt_color',
             [
                'label' => __('Hover Overlay Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_two.type_four::before  ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => 'style_four',
               ],
             ]
        );
        $this->add_control(
            'date_color',
             [
                'label' => __('Date Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_one .vertical_text_1 .date_tm , {{WRAPPER}} .blog_box.type_one .vertical_text_1 .date_tm i
                    , {{WRAPPER}}  .blog_box.type_two .date_tm ,  {{WRAPPER}} .blog_box.type_four time ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'datebg_color',
             [
                'label' => __('Date Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_two .date_tm ' => 'background: {{VALUE}}!important;', 
                ],
             ]
        );
        $this->add_control(
            'authour_color',
             [
                'label' => __('Authour Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_one .blog_inner .content .authour , {{WRAPPER}}  .blog_box.type_two .content .authour ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );

        $this->add_control(
            'comment_icon_color',
             [
                'label' => __('Comment Text  Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .blog_box .comments span , {{WRAPPER}}  .blog_box  .comments a ' => 'color: {{VALUE}}!important;', 
                ],
                'condition' => [
                    'blog_style' => ['style_two' , 'style_three']
               ],
             ]
        );

        $this->add_control(
            'comment_color',
             [
                'label' => __('Comment Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .blog_box .comments i  ' => 'color: {{VALUE}}!important;', 
                ],
                'condition' => [
                    'blog_style' => ['style_two' , 'style_three']
               ],
             ]
        );
       
        $this->add_control(
            'title_color',
             [
                'label' => __('Title Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_one  .title_22 a , {{WRAPPER}} .blog_box.type_two .content .title_22 a  ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'titleho_color',
             [
                'label' => __('Title Hover Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_one  .title_22 a:hover , {{WRAPPER}} .blog_box.type_two .content .title_22 a:hover  ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
         
        $this->add_control(
            'desc_color',
             [
                'label' => __('Description Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .blog_box .descs ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        
      
        $this->add_control(
            'link_color',
             [
                'label' => __('Link Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_one .blog_inner .content a.rd_more  , {{WRAPPER}} .blog_box.type_two .content a.rd_more   , {{WRAPPER}} .blog_box.type_five .content a.theme_btn  ' => 'color: {{VALUE}}!important;',
                    '{{WRAPPER}} .blog_box.type_five .content a.theme_btn svg path  ' => 'stroke: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'link_bg_color',
             [
                'label' => __('Link Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_five .content a.theme_btn ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => ['style_five']
               ],
             ]
        );
        $this->add_control(
            'link_bor_color',
             [
                'label' => __('Link Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_five .content a.theme_btn ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => ['style_five']
               ],
             ]
        );

        $this->add_control(
            'linkho_color',
             [
                'label' => __('Link Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_five .content a.theme_btn:hover ' => 'color: {{VALUE}}!important;',
                    '{{WRAPPER}} .blog_box.type_five .content a.theme_btn:hover svg path  ' => 'stroke: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => ['style_five']
               ],
             ]
        );
        $this->add_control(
            'linkho_bg_color',
             [
                'label' => __('Link Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_five .content a.theme_btn:hover ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => ['style_five']
               ],
             ]
        );
        $this->add_control(
            'linkho_bor_color',
             [
                'label' => __('Link Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_five .content a.theme_btn:hover ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => ['style_five']
               ],
             ]
        );


        $this->add_control(
            'border_color',
             [
                'label' => __('Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_two.type_three .content .bottm_contet ' => 'border-color: {{VALUE}}!important;', 
                ],
                'condition' => [
                    'blog_style' => ['style_three' , 'style_four']
               ],
             ]
        );

        $this->add_control(
			'hrho',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'blog_style' => 'style_four',
                ]
			]
		);


        $this->add_control(
            'hodate_color',
             [
                'label' => __('Hover Date Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_four:hover time , {{WRAPPER}} .blog_box.type_four:hover .date_tm ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => 'style_four',
                ]
             ]
        );
        $this->add_control(
            'hodatebg_color',
             [
                'label' => __('Hover Date Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_four:hover .date_tm ' => 'background: {{VALUE}}!important;', 
                ],
                'condition' => [
                    'blog_style' => 'style_four',
                ]
             ]
        );
       
 
        $this->add_control(
            'hotitle_color',
             [
                'label' => __('Title Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_four:hover  .title_22 a , {{WRAPPER}} .blog_box.type_four.active_box   .title_22 a
                  , {{WRAPPER}}  .blog_box.type_four:hover  .title_22 a span:after , {{WRAPPER}}  .blog_box.type_four.active_box   .title_22 a span:after   ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => 'style_four',
                ]
             ]
        );
         
        $this->add_control(
            'hodesc_color',
             [
                'label' => __('Description Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_four:hover .descs ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => 'style_four',
                ]
             ]
        );
        
        $this->add_control(
            'hoauthour_color',
             [
                'label' => __('Hover Authour Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_four:hover .content .authour ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => 'style_four',
                ]
             ]
        );

        $this->add_control(
            'holink_color',
             [
                'label' => __('Link Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog_box.type_four:hover .content a.rd_more ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'blog_style' => 'style_four',
                ]
             ]
        );


        $this->add_control(
            'hoborder_color',
             [
                'label' => __('Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}}  .blog_box.type_two.type_four:hover .content .bottm_contet ' => 'border-color: {{VALUE}}!important;', 
                ],
                'condition' => [
                    'blog_style' => 'style_four',
                ]
             ]
        );
      
  
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
     <section class="blog_post position-relative  <?php if($settings['ajax_loadmore'] == 'yes'): ?> ajax_posts_enabled <?php endif; ?>">
        <div class="row ajaxcontainer">
            <?php if ( get_query_var( 'paged' ) ) { 
                        $paged = get_query_var( 'paged' ); 
                } elseif ( get_query_var( 'page' ) ) { 
                        $paged = get_query_var( 'page' ); 
                } else { 
                        $paged = 1; 
                }
                  $query_args = array(
                        'post_type' => 'post',
                        'ignore_sticky_posts' => true,
                        'orderby' => 'date',
                        'paged'             => $paged,
                        'posts_per_page' => $settings['post_count'],
                        'orderby'        => $settings['query_orderby'],
                        'order'          =>  $settings['query_order'],
                    );
                    if($settings['query_category'] ) $query_args['category_name'] = $settings['query_category'];
                     
                        $blog_query = new \WP_Query( $query_args );
                    ?>
                    <?php if($blog_query->have_posts()):
                            while($blog_query->have_posts()) : $blog_query->the_post();
                            global $post;
                            $myexcerpt = wp_trim_words(get_the_excerpt(), $settings['text_limit']);  
                            $mycontent = wp_trim_words(get_the_content(), $settings['text_limit']); 
                            $featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
                            $post_video_link_get = '';
                            $post_video_link = get_post_meta(get_the_ID() , 'post_video_link', true);
                            if(!empty($post_video_link)):
                                $post_video_link_get = $post_video_link;
                            endif;
                    // while loop start ?>
                    <?php // blog style ?>
						<?php if($settings['blog_style'] == 'style_one'): ?>
                    <?php // blog style ?>    
                        <div class="<?php echo esc_attr($settings['blog_column']); ?>  ajax-wrapper">
                            <div class="blog_box type_one trans hover_1_get <?php if($settings['borerradisable'] == 'yes'): ?>borenable<?php endif; ?>">
                                <div class="blog_inner trans">
                                    <div class="vertical_text_1">
                                        <?php do_action('vankine_theme_blog_time'); ?>
                                    </div>
                                    <?php if(has_post_thumbnail()): ?>
                                        <div class="image_box trans hover_1">
                                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                                <img class="img-fluid trans" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                            </a>
                                            <?php if(get_post_meta(get_the_ID() , 'post_video_enable', true) == true): ?>
                                                <a href="<?php echo esc_url($post_video_link); ?>"  class="lightbox-image video_popup">
                                                    <i class="fi-rs-play-alt"></i>
                                                </a>
                                            <?php endif; ?>
                                            <div class="oh ho_1"></div>
                                            <div class="oh ho_2"></div>
                                            <div class="oh ho_3"></div>
                                            <div class="oh ho_4"></div>
                                        </div>
                                    <?php endif; ?>
                                        <div class="content">
                                            <div class="d-flex authour align-items-center">
                                                <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'Vankine-authour', 100 )); ?> 
                                                <?php the_author(); ?>
                                            </div>
                                            <h4 class="title_22">
                                                <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                            </h4>
                                            <?php if($settings['excerpt_enable'] == 'yes'):
                                             $excerpt = '';
                                             if (has_excerpt()): ?>
                                            <p class="descs">
                                                <?php 
                                                    $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limit']));
                                                    echo esc_attr($excerpt);
                                                ?>
                                             </p> 
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more"><?php echo esc_attr($settings['read_more']); ?> <i class="fi-rr-arrow-small-right"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php // blog style ?>              
                                <?php elseif($settings['blog_style'] == 'style_two'): ?>
                            <?php // blog style ?>
                            <div class="<?php echo esc_attr($settings['blog_column']); ?>  ajax-wrapper">
                            <div class="blog_box type_two trans hover_1_get">
                                <div class="blog_inner trans">
                                
                                    <?php if(has_post_thumbnail()): ?>
                                        <div class="image_box trans hover_1">
                                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                                <img class="img-fluid trans" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                            </a>
                                            <?php if(get_post_meta(get_the_ID() , 'post_video_enable', true) == true): ?>
                                                <a href="<?php echo esc_url($post_video_link); ?>"  class="lightbox-image video_popup">
                                                    <i class="fi-rs-play-alt"></i>
                                                </a>
                                            <?php endif; ?>
                                            <div class="oh ho_1"></div>
                                            <div class="oh ho_2"></div>
                                            <div class="oh ho_3"></div>
                                            <div class="oh ho_4"></div>
                                            <?php do_action('vankine_theme_blog_time'); ?>
                                        </div>
                                    <?php endif; ?>
                                        <div class="content">
                                            <div class="d-flex authour align-items-center">
                                                <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'Vankine-authour', 100 )); ?> 
                                                <?php the_author(); ?>
                                            </div>
                                            <h4 class="title_22">
                                                <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                            </h4>
                                            <?php if($settings['excerpt_enable'] == 'yes'):
                                             $excerpt = '';
                                             if (has_excerpt()): ?>
                                            <p class="descs">
                                                <?php 
                                                    $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limit']));
                                                    echo esc_attr($excerpt);
                                                ?>
                                             </p> 
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            <div class="bottn_flex">
                                                <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more"><?php echo esc_attr($settings['read_more']); ?> <i class="fi-rr-arrow-small-right"></i></a>
                                                <?php do_action('vankine_theme_blog_comments'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php // blog style ?>              
                                <?php elseif($settings['blog_style'] == 'style_three'): ?>
                            <?php // blog style ?>
                            <div class="<?php echo esc_attr($settings['blog_column']); ?>  ajax-wrapper">
                            <div class="blog_box type_two type_three trans hover_1_get">
                                <div class="blog_inner trans">
                                    <?php if(has_post_thumbnail()): ?>
                                        <div class="image_box trans hover_1">
                                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                                <img class="img-fluid trans" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                            </a>
                                            <?php if(get_post_meta(get_the_ID() , 'post_video_enable', true) == true): ?>
                                                <a href="<?php echo esc_url($post_video_link); ?>"  class="lightbox-image video_popup">
                                                    <i class="fi-rs-play-alt"></i>
                                                </a>
                                            <?php endif; ?>
                                            <div class="oh ho_1"></div>
                                            <div class="oh ho_2"></div>
                                            <div class="oh ho_3"></div>
                                            <div class="oh ho_4"></div>
                                       
                                        </div>
                                    <?php endif; ?>
                                        <div class="content">
                                        <?php do_action('vankine_theme_blog_time'); ?>
                                        <?php do_action('vankine_theme_blog_comments'); ?>

                                            <h4 class="title_22">
                                                <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                            </h4>
                                            <?php if($settings['excerpt_enable'] == 'yes'):
                                             $excerpt = '';
                                             if (has_excerpt()): ?>
                                            <p class="descs">
                                                <?php 
                                                    $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limit']));
                                                    echo esc_attr($excerpt);
                                                ?>
                                             </p> 
                                            <?php endif; ?>
                                            <?php endif; ?>
                                           <div class="bottm_contet d-flex align-items-center">
                                                <div class="d-flex authour align-items-center">
                                                    <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'Vankine-authour', 100 )); ?> 
                                                    <?php the_author(); ?>
                                                </div>
                                                <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more"><?php echo esc_attr($settings['read_more']); ?><i class="fi-rr-arrow-small-right"></i></a>
                                       
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php // blog style ?>              
                                <?php elseif($settings['blog_style'] == 'style_four'): ?>
                            <?php // blog style ?>
                            <div class="<?php echo esc_attr($settings['blog_column']); ?>  ajax-wrapper">
                            <div class="blog_box type_two type_three type_four trans hover_1_get   hover_1 <?php if($settings['activeenable'] == 'yes'): ?>active_box<?php endif; ?>">
                                <?php if(has_post_thumbnail()): ?>  
                                    <img class="img-fluid trans" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                <?php endif; ?>
                                <div class="oh ho_1"></div>
                                <div class="oh ho_2"></div>
                                <div class="oh ho_3"></div>
                                <div class="oh ho_4"></div>
                                <div class="blog_inner trans">
                                        <div class="content">
                                            <div class="d-flex top_c align-items-center">
                                                <?php do_action('vankine_theme_blog_time'); ?>
                                                
                                            </div>
                                            <h4 class="title_22">
                                                <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                            </h4>
                                            <?php if($settings['excerpt_enable'] == 'yes'):
                                             $excerpt = '';
                                             if (has_excerpt()): ?>
                                            <p class="descs">
                                                <?php 
                                                    $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limit']));
                                                    echo esc_attr($excerpt);
                                                ?>
                                             </p> 
                                            <?php endif; ?>
                                            <?php endif; ?>
                                           <div class="bottm_contet d-flex align-items-center">
                                                <div class="d-flex authour align-items-center">
                                                    <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'Vankine-authour', 100 )); ?> 
                                                    <?php the_author(); ?>
                                                </div>
                                                <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more"><?php echo esc_attr($settings['read_more']); ?><i class="fi-rr-arrow-small-right"></i></a>
                                       
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php // blog style ?>              
                                <?php elseif($settings['blog_style'] == 'style_five'): ?>
                            <?php // blog style ?>
                            <div class="<?php echo esc_attr($settings['blog_column']); ?>  ajax-wrapper">
                            <div class="blog_box type_two type_three type_five trans hover_1_get">
                                <div class="blog_inner trans">
                                    <?php if(has_post_thumbnail()): ?>
                                        <div class="image_box trans hover_1">
                                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                                <img class="img-fluid trans" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                                            </a>
                                            <?php if(get_post_meta(get_the_ID() , 'post_video_enable', true) == true): ?>
                                                <a href="<?php echo esc_url($post_video_link); ?>"  class="lightbox-image video_popup">
                                                    <i class="fi-rs-play-alt"></i>
                                                </a>
                                            <?php endif; ?>
                                            <div class="oh ho_1"></div>
                                            <div class="oh ho_2"></div>
                                            <div class="oh ho_3"></div>
                                            <div class="oh ho_4"></div>
                                       
                                        </div>
                                    <?php endif; ?>
                                        <div class="content">
                                        <?php do_action('vankine_theme_blog_time'); ?>
                                            <div class="d-flex authour align-items-center">
                                                <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'Vankine-authour', 100 )); ?> 
                                                <?php the_author(); ?>
                                            </div>
                                            <h4 class="title_22">
                                                <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                                            </h4>
                                            <?php if($settings['excerpt_enable'] == 'yes'):
                                             $excerpt = '';
                                             if (has_excerpt()): ?>
                                            <p class="descs">
                                                <?php 
                                                    $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limit']));
                                                    echo esc_attr($excerpt);
                                                ?>
                                             </p> 
                                            <?php endif; ?>
                                            <?php endif; ?>
                                           <div class="bottm_contet d-flex align-items-center">
                                                <a href="<?php echo esc_url(get_permalink()); ?>"  class="theme_btn"><?php echo esc_attr($settings['read_more']); ?>
                                                <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M1 11L11 1M11 1H3.5M11 1V8.5" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php // blog style ?>              
                                <?php endif; ?>
                            <?php // blog style ?>                        
	
                    <?php endwhile; // while loop end ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; // Post Endif after loop end  ?>
        </div>
    <!--End tab-content-->
    <?php if($settings['pagination_enable'] == true):?>
        <div class="row">
            <div class="col-lg-12">
                <div class="pagination_blog pagination-area pagination">
                
                    <?php
                          if($settings['ajax_loadmore'] == 'yes'):
                            $prev = '';
                            $next = '<span class="theme_btn">'.$settings['load_more'].'</span>';
                            $type = 'plain';
                        elseif($settings['pagination_enable'] == 'yes'):
                            $prev = '<i class="fa fa-angle-left"></i>';
                            $next = '<i class="fa fa-angle-right"></i>';
                            $type = 'list';
                        endif;
                        $pagination = 999999999;
                        echo paginate_links( array(
                            'base' => str_replace( $pagination, '%#%', get_pagenum_link( $pagination ) ),
                            'format' => '?paged=%#%',
                             'current' => max(0, $paged),
                            'total' => $blog_query->max_num_pages,
                            'prev_text' => $prev,
                            'next_text' => $next,
                            'type'=> $type,
                            'add_args' => false
                        ) );
                    ?>          
                </div>
            </div>     
        </div> 
    <?php endif; ?>  
</section>
 
        <?php
    }
}

         