<?php

namespace  Vankineaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Extra_items_btn_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-extra-items-v1';
    }

    public function get_title()
    {
        return __('Header Extra Items V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('header_extra_settings',
        [ 
            'label' => __('Header Extra Settings', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );

        $this->add_control(
            'extra_type',
            [
                'label' => __('Extra Type', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one'   => esc_html__( 'Search And Option Panel Button', 'vankine-addons' ),
                    'style_two'   => esc_html__( 'Get A Quote Dropdown', 'vankine-addons' ),
                ],
                'default' => 'style_one',
            ]
        );
      
        $this->add_control(
            'search_enable',
            [
                'label' => __('Search show / hide', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'extra_type' => 'style_one'
                ],
            ]
        );
        
        $this->add_control(
            'option_panel_enable',
            [
                'label' => __('Option Panel Show / Hide', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'extra_type' => 'style_one'
                ],
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__( 'Alignment', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Left', 'vankine-addons' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'vankine-addons' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Right', 'vankine-addons' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items  ' => 'justify-content: {{VALUE}}!important;',
                ],
                'condition' => [
                    'extra_type' => 'style_one'
                ],
            ]
        );

        $this->add_control(
            'buttono_text',
            [
                'label' => __('Button Text', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Get A Quote', 'vankine-addons'),
                'placeholder' => __('Type your text here', 'vankine-addons'),
                'condition' => [
                    'extra_type' => 'style_two'
                ],
            ]
        );

        $this->add_control(
            'heading_texts',
            [
                'label' => __('Heding Text', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Select a Product to Get a Quote:', 'vankine-addons'),
                'placeholder' => __('Type your text here', 'vankine-addons'),
                'condition' => [
                    'extra_type' => 'style_two'
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'vankine-addons' ),
					'icon'  => esc_html__( 'Icon', 'vankine-addons' ), 
				], 
                'default' => 'icon' , 
			]
		);
        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );
        $repeater->add_control(
            'switcher_c_icon',
            [
                'label' => esc_html__( 'Use Custom Icon', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        
        $repeater->add_control(
            'icon',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => vankine_get_icon(),
                'default' => 'fi-rs-user' , 
                'condition' => [
                    'switcher_c_icon' => 'yes' ,
                ]
            ]
        );
        $repeater->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [
                    'switcher_c_icon' => '',
                ]
            ]
        );

        $repeater->add_control(
            'list_items',
            [
                'label' => __('List Items', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default text', 'vankine-addons'),
                'placeholder' => __('Type your text here', 'vankine-addons'),
              
            ]
        );
        $repeater->add_control(
            'list_link',
            [
                'label' => __('Link', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'vankine-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );
        $this->add_control(
            'content_repeaters',
            [
                'label' => __('Faqs Box Content', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                     'list_items' =>  __('Default text', 'vankine-addons'), 
                     'list_items' =>  __('Default text', 'vankine-addons'), 
                     'list_items' =>  __('Default text', 'vankine-addons'), 
                     'list_items' =>  __('Default text', 'vankine-addons'), 
                    ],
                ],
                'title_field' => '{{{ list_items }}}',
                'condition' => [
                    'extra_type' => 'style_two'
                ],
            ]
        );
         
        $this->end_controls_section();

        
        $this->start_controls_section('header_extra_css_two',
        [ 
            'label' => __('Header Extra Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'extra_type' => 'style_two'
            ],
        ]);

        $this->add_control(
            'button_colors',
            [
                'label' => __('Button Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop_btn_content button ' => 'color: {{VALUE}}!important;',
                ],
            ]
        ); 

        $this->add_control(
            'button_bg_colorss',
            [
                'label' => __('Button bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop_btn_content button ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;', 
                ],
            ]
        ); 
        $this->add_control(
            'hbutton_color',
            [
                'label' => __('Button Hover Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop_btn_content button:hover ' => 'color: {{VALUE}}!important;',
                ],
            ]
        ); 

        $this->add_control(
            'hbutton_bg_colors',
            [
                'label' => __('Button Hover Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop_btn_content button:hover ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;', 
                ],
            ]
        ); 
        $this->add_control(
            'dop_color',
            [
                'label' => __('Dropdown Text Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop_btn_content .dropdown-menu h4 , {{WRAPPER}} .drop_btn_content .dropdown-menu li a' => 'color: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'dop_colori',
            [
                'label' => __('Dropdown Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop_btn_content .dropdown-menu li .icon i ' => 'color: {{VALUE}}!important;',
                ],
            ]
        ); 

        $this->add_control(
            'dopbg_color',
            [
                'label' => __('Dropdown Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop_btn_content .dropdown-menu ' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 
       
       
        $this->end_controls_section(); 

        $this->start_controls_section('header_extra_css',
        [ 
            'label' => __('Header Extra Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
                'extra_type' => 'style_one'
            ],
        ]);

        $this->add_control(
            'icon_color',
            [
                'label' => __('Search Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search i ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'search_enable' => 'yes'
                ],
            ]
        ); 

        $this->add_control(
            'icon_color_two',
            [
                'label' => __('Option Panel Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items  .contact-toggler svg path' => 'stroke: {{VALUE}}!important;',
                ],
                'condition' => [
                    'option_panel_enable' => 'yes'
                ],
            ]
        ); 

        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Icon Background Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search , {{WRAPPER}} .header_extra_items  .contact-toggler ' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'icon_border_width',
            [
                'label' => esc_html__( 'Icon Border Width', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search  , {{WRAPPER}} .header_extra_items  .contact-toggler ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->add_control(
            'border_style',
            [
            'label' => __('Border Types', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'dotted' => __( 'Dotted', 'vankine-addons' ),
                'dashed' => __( 'Dashed', 'vankine-addons' ),
                'solid' => __( 'Solid', 'vankine-addons' ),
                'doubled' => __( 'Doubled', 'vankine-addons' ),
            ],
            'default' => '' , 
            'selectors' => [
                '{{WRAPPER}} .header_extra_items .search , {{WRAPPER}} .header_extra_items  .contact-toggler ' => 'border-style: {{VALUE}}!important;',
            ],
            ]
        );


        $this->add_control(
            'icon_border_colors',
            [
                'label' => __('Icon Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search , {{WRAPPER}} .header_extra_items  .contact-toggler ' => 'border-color: {{VALUE}}!important;',
                ],
            ]
        ); 

        $this->add_control(
            'icon_padding',
            [
                'label' => esc_html__( 'Icon Padding', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search  , {{WRAPPER}} .header_extra_items  .contact-toggler ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_control(
            'icon_radius',
            [
                'label' => esc_html__( 'Icon Border Radius', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .header_extra_items .search  , {{WRAPPER}} .header_extra_items  .contact-toggler ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->end_controls_section(); 

    } 
    protected function render(){
    $settings = $this->get_settings_for_display();
    ?>
    <?php if($settings['extra_type'] == 'style_one'): ?>
    <div class="d-flex flex-wrap align-items-center header_extra_items">
        <?php if($settings['search_enable'] == 'yes'): ?>
        <div class="search search-toggler">
            <i class="fi-rs-search"></i>
        </div>
        <?php endif;?>
        <?php if($settings['option_panel_enable'] == 'yes'): ?>
        <div class="contact-toggler">
            <svg width="18" height="19" viewBox="0 0 18 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M0.75 3.25C0.75 2.65326 0.987053 2.08097 1.40901 1.65901C1.83097 1.23705 2.40326 1 3 1H5.25C5.84674 1 6.41903 1.23705 6.84099 1.65901C7.26295 2.08097 7.5 2.65326 7.5 3.25V5.5C7.5 6.09674 7.26295 6.66903 6.84099 7.09099C6.41903 7.51295 5.84674 7.75 5.25 7.75H3C2.40326 7.75 1.83097 7.51295 1.40901 7.09099C0.987053 6.66903 0.75 6.09674 0.75 5.5V3.25ZM0.75 13C0.75 12.4033 0.987053 11.831 1.40901 11.409C1.83097 10.9871 2.40326 10.75 3 10.75H5.25C5.84674 10.75 6.41903 10.9871 6.84099 11.409C7.26295 11.831 7.5 12.4033 7.5 13V15.25C7.5 15.8467 7.26295 16.419 6.84099 16.841C6.41903 17.2629 5.84674 17.5 5.25 17.5H3C2.40326 17.5 1.83097 17.2629 1.40901 16.841C0.987053 16.419 0.75 15.8467 0.75 15.25V13ZM10.5 3.25C10.5 2.65326 10.7371 2.08097 11.159 1.65901C11.581 1.23705 12.1533 1 12.75 1H15C15.5967 1 16.169 1.23705 16.591 1.65901C17.0129 2.08097 17.25 2.65326 17.25 3.25V5.5C17.25 6.09674 17.0129 6.66903 16.591 7.09099C16.169 7.51295 15.5967 7.75 15 7.75H12.75C12.1533 7.75 11.581 7.51295 11.159 7.09099C10.7371 6.66903 10.5 6.09674 10.5 5.5V3.25ZM10.5 13C10.5 12.4033 10.7371 11.831 11.159 11.409C11.581 10.9871 12.1533 10.75 12.75 10.75H15C15.5967 10.75 16.169 10.9871 16.591 11.409C17.0129 11.831 17.25 12.4033 17.25 13V15.25C17.25 15.8467 17.0129 16.419 16.591 16.841C16.169 17.2629 15.5967 17.5 15 17.5H12.75C12.1533 17.5 11.581 17.2629 11.159 16.841C10.7371 16.419 10.5 15.8467 10.5 15.25V13Z"
                    stroke="#0F3567" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
        </div>
        <?php endif;?>
    </div>
    <?php elseif($settings['extra_type'] == 'style_two'):
        
        ?>
    <div class="dropdown drop_btn_content">
        <button class="btn dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
            <?php echo esc_attr($settings['buttono_text']); ?>
        </button>
 
            <ul class="dropdown-menu" >
            <?php if(!empty($settings['heading_texts'])): ?>
                <h4><?php echo esc_attr($settings['heading_texts']); ?></h4>
                <?php endif; ?>
            <?php if(!empty($settings['content_repeaters'])): ?>
                <?php foreach($settings['content_repeaters'] as  $key => $content_repeaters):
                     $target = $content_repeaters['list_link']['is_external'] ? ' target="_blank"' : '';
                     $nofollow = $content_repeaters['list_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
                    
                    <li>  <?php if($content_repeaters['icon_type'] == 'image'): ?>
                        <?php if(!empty($content_repeaters['image']['url'])): ?>
                            <div class="icon">
                                <img src="<?php echo esc_url($content_repeaters['image']['url']); ?>" alt="img" />
                            </div>
                        <?php endif; ?>
                    <?php elseif($content_repeaters['icon_type'] == 'icon'): ?>
                       
                        <?php if($content_repeaters['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($content_repeaters['icon'])): ?>
                            <div class="icon trans">
                                <i class="<?php echo esc_attr($content_repeaters['icon']); ?>"></i>
                            </div>
                        <?php endif; ?>	
                        <?php else: ?>
                                <?php if(!empty($content_repeaters['icon_lib'])): ?>
                                    <div class="icon trans">
                                        <?php \Elementor\Icons_Manager::render_icon($content_repeaters['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                                    </div>
                                <?php endif; ?>	
                        <?php endif; ?>	
                
                    <?php endif; ?> 
                    <a class="links" href="<?php echo esc_url($content_repeaters['list_link']['url']); ?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <?php echo esc_attr($content_repeaters['list_items']); ?></a> </li>
                <?php endforeach; ?>
                <?php endif;?>
            
     
            </ul>
       
        
    </div>
    <?php endif;?>

<?php
    }
}