<?php

namespace  Vankineaddons\Core\Widgets\Footer;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Foo_post_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-post-v1';
    }

    public function get_title()
    {
        return __('Footer Post  V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['104'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('post_content',
        [ 
            'label' => __('Post Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
 
        $this->add_control(
            'post_type',
            [
                'label' => __('Post Type', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'service'   => esc_html__( 'Service', 'vankine-addons' ),
                    'post'   => esc_html__( 'Post', 'vankine-addons' ),
                    'portfolio'   => esc_html__( 'Portfolio', 'vankine-addons' ), 
                ],
                'default' => 'post',
            ]
        );
   
        $this->add_control(
            'post_count',
            [
                'label' => __('Blog Count', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 10,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
            ]
        );
     
        $this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date'       => esc_html__( 'Date', 'vankine-addons' ),
					'title'      => esc_html__( 'Title', 'vankine-addons' ),
					'menu_order' => esc_html__( 'Menu Order', 'vankine-addons' ),
					'rand'       => esc_html__( 'Random', 'vankine-addons' ),
				),
                'default' => 'date',
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'vankine-addons' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESc',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'vankine-addons' ),
					'ASC'  => esc_html__( 'ASC', 'vankine-addons' ),
				),
			]
        );

        $this->add_control(
            'display',
            [
                'label' => __('Display', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'datet'   => esc_html__( 'Date', 'vankine-addons' ),
                    'authour'   => esc_html__( 'Authour', 'vankine-addons' ),
                 
                ],
                'default' => 'authour',
            ]
        );
   
       
     
        $this->end_controls_section();
        $this->start_controls_section('custom_css',
        [ 
            'label' => __('Custom Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
        );
         
        $this->add_control(
            'overlay_color',
             [
                'label' => __('Overlay Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post_foo_box .foo_post_content .image_box:before  ' => 'background: {{VALUE}}!important;',
                ],
             ]
        );
            
       
        $this->add_control(
            'title_color',
             [
                'label' => __('Title Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .post_foo_box .foo_post_content .content .title_18 a ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'other_color',
             [
                'label' => __('Authour / Date Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post_foo_box .foo_post_content .content p , {{WRAPPER}} .post_foo_box .foo_post_content .content .date_tm  ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
      
        
      
  
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
     <section class="post_foo_box">
            <?php  $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                $query_args = array(
                    'post_type' => $settings['post_type'], 
                    'ignore_sticky_posts' => true,
                    'paged'             => $paged,
                    'posts_per_page' => $settings['post_count'],
                    'orderby'        => $settings['query_orderby'],
                    'order'          =>  $settings['query_order'],
                );
                $post_query = new \WP_Query( $query_args );
                if($post_query->have_posts()):
                while($post_query->have_posts()) : $post_query->the_post();
                global $post;
                $featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
                    // while loop start ?>
                <div class="foo_post_content">
                    <?php if(has_post_thumbnail()): ?>
                        <a class="image_box trans" href="<?php echo esc_url(get_permalink()); ?>">
                            <img class="img-fluid trans" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
                            <svg class="trans" width="55" height="55" viewBox="0 0 55 55" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="28" cy="27" r="20" fill="white"/>
                    <circle cx="27.5" cy="27.5" r="27.5" fill="white" fill-opacity="0.1"/>
                    <path d="M22 33.25L33.25 22M33.25 22H24.8125M33.25 22V30.4375" stroke="#2D947A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
                        </a>
                    <?php endif; ?>
                     <div class="content">
                     <h4 class="title_18">
                        <?php the_title('<a href="' .  esc_url(get_permalink()) . '">', '</a>'); ?>
                    </h4>
                    <?php if($settings['display'] == 'authour'): ?> 
                        <p> <?php the_author(); ?> </p>
                    <?php else:
                    do_action('vankine_theme_blog_time');
                    endif; ?>
                    </div>
                </div>      
                <?php endwhile; // while loop end ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; // Post Endif after loop end  ?>
      
 
</section>
 
        <?php
    }
}

         