<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Testivertical_carousel_v1 extends \Elementor\Widget_Base{
        public function get_name()
        {
            return 'vankine-testimonil-vertical-v1';
        }

        public function get_title()
        {
            return __('Testimonial Carousel  V2', 'vankine-addons');
        }

        public function get_icon()
        {
            return 'icon-vankine-icon';
        }

        public function get_categories()
        {
            return ['101'];
        }

        protected function register_controls(){
        // style one start
        $this->start_controls_section('test_settings',
        [ 
            'label' => __('Testimonial Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );

        $this->add_control(
            'testi_style',
            [
            'label' => __('Testimonial Styles', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'vankine-addons' ),
                'style_two' => __( 'Style Two', 'vankine-addons' ),
            ],
            'default' => __('style_one' , 'vankine-addons'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'image_enable',
        [
            'label' => __('Image Enable', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'vankine-addons'),
            'label_off' => __('No', 'vankine-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => __('Image', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'image_enable' => 'yes',
                ],
            ]
        );
        $repeater->add_control(
            'name',
            [
            'label'       => esc_html__( 'Name', 'vankine-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default' =>  esc_html__( 'Jacob Leonardo' , 'vankine-addons'),
        ]);
        $repeater->add_control(
            'designation',
            [
            'label'       => esc_html__( 'Designation', 'vankine-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default' =>  esc_html__( 'Senior Manager of Excel Solution' , 'vankine-addons'),
        ]);
        $repeater->add_control(
            'comments',
            [
            'label'       => esc_html__( 'Comment', 'vankine-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXTAREA,
            'default' =>  esc_html__( 'While running an early stage startup everything feels
            hard, that’s why it’s been so nice to have our accounting
            feel easy. We recommed Qetus.' , 'vankine-addons'),
        ]);
        $repeater->add_control(
            'rating_enable',
        [
            'label' => __('Rating Enable', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'vankine-addons'),
            'label_off' => __('No', 'vankine-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
        );
        $repeater->add_control(
            'rating_one',
            [
                'label' => __( 'Rating', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' =>  'two' , 
                'options' => [
                    'one' => __('1', 'vankine-addons'),
                    'two' => __('2', 'vankine-addons'),
                    'three' => __('3', 'vankine-addons'),
                    'four' => __('4', 'vankine-addons'),
                    'five' => __('5', 'vankine-addons'),
                ],
                'condition' => [
                    'rating_enable' => 'yes',
                ],
            ]
        );
        $repeater->add_control(
            'rating_text',
            [
            'label'       => esc_html__( 'Rating Text', 'vankine-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXTAREA,
            'default' =>  esc_html__( '4.8 Of 8 (Reviews)' , 'vankine-addons'),
            'condition' => [
                'rating_enable' => 'yes', 
            ],
        ]);
        

        $this->add_control(
            'testi_repeater',
            [
                'label' => __('Testimonial Content', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image_enable' => 'yes' ,
                        'name' =>  __('Fleix Everard ', 'vankine-addons'),
                        'designation' =>  __('HR, Blue Soft Sol', 'vankine-addons'),
                        'comments'  =>  __('Sit amet consectetur adipi scey
                        elit Condimentum quam nun facilisis condim entum pellentesque sapien quis tincidunt pulvinar non sem nisle eget enim elit. Imperdiet venenatis sed libero lectus sed cursus', 'vankine-addons'),
                        'rating_enable' => 'yes' ,
                        'rating_one' => 'three' ,
                    ],
                    [
                        'image_enable' => 'yes' ,
                        'name' =>  __('Boris Elbert ', 'vankine-addons'),
                        'designation' =>  __('Green Tech', 'vankine-addons'),
                        'comments'  =>  __('Sit amet consectetur adipi scey
                        elit Condimentum quam nun facilisis condim entum pellentesque sapien quis tincidunt pulvinar non sem nisle eget enim elit. Imperdiet venenatis sed libero lectus sed cursus', 'vankine-addons'),
                        'rating_enable' => 'yes' ,
                        'rating_one' => 'three'
                    ], 
                    [
                        'image_enable' => 'yes' ,
                        'name' =>  __('Ivor Herbert', 'vankine-addons'),
                        'designation' =>  __('Manager, Airlines', 'vankine-addons'),
                        'comments'  =>  __('Sit amet consectetur adipi scey
                        elit Condimentum quam nun facilisis condim entum pellentesque sapien quis tincidunt pulvinar non sem nisle eget enim elit. Imperdiet venenatis sed libero lectus sed cursus', 'vankine-addons'),
                        'rating_enable' => 'yes' ,
                        'rating_one' => 'three'
                    ]
                ],
                'title_field' => '{{{ name }}}',

            ]
        );
    
         

    $this->end_controls_section();

    $this->start_controls_section('csutomcss',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    
    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'background_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .testimonial_box.type_one , {{WRAPPER}} .testimonial_box.type_four .testimonial_box_inner ',
        ]
    );

    
    $this->add_control(
        'bgh1s',
        [
        'type' => \Elementor\Controls_Manager::DIVIDER, 
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Background::get_type(),
        [
            'name' => 'backgroundtwo_color',
            'types' => [ 'classic', 'gradient' ],
            'selector' => '{{WRAPPER}} .slick-slide.slick-current.slick-active .testimonial_box.type_four .testimonial_box_inner , {{WRAPPER}} .testimonial_box.type_four:hover .testimonial_box_inner ',
            'condition' => [
                'testi_style' => 'style_two',
            ],
        ]
    );
    
    $this->add_control(
        'bgh2s',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            'condition' => [
                'testi_style' => 'style_two',
            ],
        ]
    );
    $this->add_control(
        'rating_color',
         [
            'label' => __('Rating Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .top_content p i  , {{WRAPPER}} .testimonial_box.type_four .testimonial_box_inner .lower_content .rating p i ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );

    $this->add_control(
        'ratingtext_color',
         [
            'label' => __('Rating Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_four .testimonial_box_inner .lower_content .rating .rating_text ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_two',
            ],
         ]
    );

    $this->add_control(
        'rating_ho_colors',
         [
            'label' => __('Rating Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .slick-slide.slick-current.slick-active .testimonial_box.type_four .testimonial_box_inner .lower_content .rating p i , {{WRAPPER}} .testimonial_box.type_four:hover .testimonial_box_inner .lower_content .rating p i ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_two',
            ],
         ]
    );

    $this->add_control(
        'ratingtextho_color',
         [
            'label' => __('Rating Text Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .slick-slide.slick-current.slick-active  .testimonial_box.type_four .testimonial_box_inner .lower_content .rating .rating_text
                , {{WRAPPER}}  .testimonial_box.type_four:hover .testimonial_box_inner .lower_content .rating .rating_text ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_two',
            ],
         ]
    );

    $this->add_control(
        'desc_color',
         [
            'label' => __('Description Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .top_content .t_comment , {{WRAPPER}} .testimonial_box.type_four .testimonial_box_inner .t_comment  ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );

    
    $this->add_control(
        'desc_hover_color',
         [
            'label' => __('Description Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .slick-slide.slick-current.slick-active .testimonial_box.type_four .testimonial_box_inner .t_comment , {{WRAPPER}}  .testimonial_box.type_four:hover .testimonial_box_inner .t_comment  ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_two',
            ],
         ]
    );
  
    $this->add_control(
        'image_bg',
         [
            'label' => __('Image Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .lower_content .image_box svg path , {{WRAPPER}}  .testimonial_box.type_four .testimonial_box_inner .image_box svg path ' => 'fill: {{VALUE}}!important;', 
            ],
         ]
    );
 
    $this->add_control(
        'image_hover_bg',
         [
            'label' => __('Image Bg Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .slick-slide.slick-current.slick-active .testimonial_box.type_four .testimonial_box_inner .image_box svg path , {{WRAPPER}} .testimonial_box.type_four:hover .testimonial_box_inner .image_box svg path ' => 'fill: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_two',
            ],
         ]
    );
    $this->add_control(
        'auth_color',
         [
            'label' => __('Authour Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .lower_content .cont .title_no_a_22 , {{WRAPPER}} .testimonial_box.type_four .testimonial_box_inner .lower_content .title_no_a_18 ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );
    $this->add_control(
        'auth_ho_color',
         [
            'label' => __('Authour Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .slick-slide.slick-current.slick-active .testimonial_box.type_four .testimonial_box_inner .lower_content .title_no_a_18 , {{WRAPPER}} .testimonial_box.type_four:hover .testimonial_box_inner .lower_content .title_no_a_18 ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_two',
            ],
         ]
    );
    $this->add_control(
        'desg_color',
         [
            'label' => __('Job Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box .cont p  , {{WRAPPER}} .testimonial_box.type_four .testimonial_box_inner .lower_content .cont p ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );
    $this->add_control(
        'desg_hocolor',
         [
            'label' => __('Job Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .slick-slide.slick-current.slick-active .testimonial_box.type_four .testimonial_box_inner .lower_content .cont p, {{WRAPPER}} .testimonial_box.type_four:hover .testimonial_box_inner .lower_content .cont p ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_two',
            ],
         ]
    );
    $this->add_control(
        'quote_bg_color',
         [
            'label' => __('Quote Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .flaticon-right-quote ' => 'background: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_one',
            ],
         ]
    );

    $this->add_control(
        'quote_teobg_color',
         [
            'label' => __('Quote Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one:after ' => 'background: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_one',
            ],
         ]
    );
    
    
    $this->add_control(
        'quote_color',
         [
            'label' => __('Quote  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .flaticon-right-quote ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_one',
            ],
         ]
    );

    $this->end_controls_section();

    $this->start_controls_section('owl_dot_style',
    [ 
        'label' => __('Dot Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    

    $this->add_control(
        'dots_display',
        [
        'label' => __('Dots Enable / Disabel', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'dot_true' => __( 'Block', 'vankine-addons' ),
            'dot_false' => __( 'none', 'vankine-addons' ),
        ],
        'default' => 'dot_true' , 
       
        ]
    ); 

    $this->add_responsive_control(
        'dotalignment',
        [
            'label' => esc_html__( 'Alignment', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'default' => 'center',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'dot_left',
        [
            'label' => __('Dot Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'left',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );

    $this->add_control(
        'dot_right',
        [
            'label' => __('Dot Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'right',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );
   

    $this->add_control(
        'dot_color',
         [
            'label' => __('Dot One Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span , {{WRAPPER}}  .slick-dots li button ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 
    $this->add_control(
        'dot_ac_color',
         [
            'label' => __('Dot One Active / Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover ' => 'border-color: {{VALUE}}!important;',
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover span , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span , {{WRAPPER}}  .slick-dots li.slick-active button ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 

    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
    <?php if($settings['testi_style'] == 'style_two'): ?>
 
    <section class="tsingle_two position-relative">

    <div class="slickslider">
        <?php foreach($settings['testi_repeater'] as $test_block):?>
                <div class="testimonial_box type_four">
                <div class="testimonial_box_inner">
                <svg class="bg" width="303" height="229" viewBox="0 0 303 229" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M303 184.199L287.927 175.452L302.598 166.936L302.732 166.861V149.356L303 149.2L302.732 149.044V131.544L287.938 122.953L302.614 114.433L302.748 114.357V96.2385L287.274 105.222L287.14 105.298V122.49L287.129 122.485V140.297L273.074 148.457C272.945 148.327 272.779 148.23 272.597 148.182V114.05L257.524 105.303V87.8039L243.196 79.4878C243.223 79.3962 243.239 79.3046 243.239 79.2077C243.239 79.1108 243.223 79.0192 243.196 78.933L257.39 70.6923L257.524 70.6169V53.4353L272.045 61.8645V97.1703L286.636 88.698C286.829 88.8919 287.092 89.0104 287.381 89.0104C287.959 89.0104 288.431 88.5364 288.431 87.9547C288.431 87.4646 288.099 87.0552 287.649 86.9367V53.1337L302.609 44.4459L302.743 44.3705V26.2518L287.649 35.0149V34.9988L272.308 43.9019L256.967 34.9988V52.8159L242.044 61.4821L241.91 61.5575V78.1951C241.46 78.3136 241.128 78.723 241.128 79.2131C241.128 79.7032 241.46 80.1126 241.91 80.2311V96.8687L256.983 105.616V122.803L242.446 131.243V114.056L227.379 105.298V104.985L227.111 105.142L226.843 104.985V105.298L211.904 113.969L211.77 114.045V132.164L226.361 123.691C226.554 123.885 226.816 124.004 227.105 124.004C227.395 124.004 227.662 123.885 227.85 123.691L241.905 131.851V167.162L257.246 158.259L272.051 166.85L286.856 175.446L272.319 183.886L272.051 183.73V184.042L271.783 184.199L272.051 184.355V201.854L287.124 210.601V226.926C286.674 227.045 286.342 227.454 286.342 227.944C286.342 228.526 286.813 229 287.391 229C287.97 229 288.441 228.526 288.441 227.944C288.441 227.847 288.425 227.756 288.398 227.67L302.593 219.429L302.727 219.354V201.235L287.654 209.982V193.107L303 184.199ZM287.675 105.61L302.213 97.1703V114.045L287.675 122.485V105.61ZM302.197 166.543L287.659 174.983V158.108L302.197 149.668V166.543ZM302.197 148.731L287.659 140.291V123.417L302.197 131.857V148.731ZM287.397 140.76L301.934 149.2L295.33 153.035L287.397 157.64L273.336 149.48C273.358 149.394 273.379 149.302 273.379 149.205C273.379 149.108 273.363 149.017 273.336 148.931L287.397 140.76ZM272.056 131.862V148.182C271.874 148.23 271.708 148.327 271.579 148.457L264.793 144.514L257.524 140.297V123.422L264.793 127.639L272.056 131.862ZM272.581 61.8645L287.118 53.4245V70.2991L272.581 78.7391V61.8645ZM272.581 96.2385V79.3639L287.118 70.9239V86.9367C286.668 87.0552 286.336 87.4646 286.336 87.9547C286.336 88.0517 286.352 88.1432 286.379 88.2294L272.581 96.2385ZM287.675 35.6235L302.213 27.1835V44.0581L287.675 52.4981V35.6235ZM287.113 52.8051L272.576 61.2451V44.3705L287.113 35.9305V52.8051ZM257.508 35.9305L272.045 44.3705V61.2451L257.524 52.8159V52.4981L257.514 52.5035V35.9305H257.508ZM256.983 53.4299V70.3045L242.928 78.4644C242.8 78.3352 242.634 78.2382 242.451 78.1897V61.8645L256.983 53.4299ZM242.451 96.5509V80.2257C242.634 80.1772 242.8 80.0856 242.928 79.951L256.989 88.1109V104.985L242.451 96.5509ZM272.056 114.363V131.237L264.788 127.02L257.519 122.803V105.928L272.056 114.363ZM212.311 131.237V114.363L226.848 105.923V121.935C226.398 122.054 226.066 122.463 226.066 122.953C226.066 123.05 226.082 123.142 226.109 123.228L212.311 131.237ZM227.379 121.935V105.923L241.916 114.363V131.237L228.123 123.234C228.145 123.147 228.166 123.056 228.166 122.959C228.166 122.463 227.828 122.054 227.379 121.935ZM242.451 131.862L256.989 123.422V140.297L242.451 148.737V131.862ZM242.451 149.356L256.989 140.916V157.791L242.451 166.231V149.356ZM257.519 157.796V140.921L264.788 145.139L271.312 148.925C271.29 149.011 271.269 149.103 271.269 149.2C271.269 149.69 271.601 150.099 272.051 150.218V166.231L257.519 157.796ZM272.592 150.218C272.774 150.169 272.94 150.078 273.069 149.943L287.124 158.103V174.978L272.586 166.538V150.218H272.592ZM287.129 175.915L287.397 175.759L287.665 175.915L301.934 184.199L287.397 192.639L272.86 184.199L287.129 175.915ZM272.592 184.662L287.129 193.102V209.976L272.592 201.536V184.662ZM302.197 202.161V219.036L288.141 227.196C288.013 227.066 287.847 226.969 287.665 226.921V210.596L302.197 202.161ZM213.093 96.7071C213.093 96.6101 213.077 96.5186 213.05 96.4324L227.245 88.1917L227.379 88.1163V53.1337L241.348 45.0222C241.541 45.2915 241.852 45.4693 242.205 45.4693C242.784 45.4693 243.255 44.9953 243.255 44.4136C243.255 43.9235 242.923 43.5141 242.473 43.3957V26.2518L227.4 34.9988V17.8118L211.791 8.75238V26.8765L226.58 35.462L212.038 43.9073L197.977 35.7474C197.999 35.6612 198.02 35.5697 198.02 35.4727C198.02 34.891 197.549 34.4171 196.97 34.4171C196.392 34.4171 195.92 34.891 195.92 35.4727C195.92 35.9629 196.253 36.3722 196.703 36.4907V52.5035V70.3153L181.897 78.9115L167.36 70.4715L182.031 61.9561L182.165 61.8807V44.3652L182.433 44.209L182.165 44.0528V26.8712L197.104 18.1996L197.238 18.1242V0L181.764 8.98398L181.63 9.05939V26.2464L167.092 17.8064V17.494L166.825 17.6502L151.484 8.74699V25.6916C151.302 25.7401 151.136 25.837 151.007 25.9663L136.952 17.8064V0.00538608L121.879 8.75238V8.74699L106.405 17.731L106.271 17.8064V34.9934L91.7335 26.5534V26.241L91.4656 26.3972L91.1978 26.241V26.5534L76.3928 35.1442L61.0521 26.241V44.0581L46.5309 52.4927V35.3058L30.9278 26.2464L15.8549 17.494V35.3058L1.79975 43.4657C1.60692 43.2718 1.34445 43.1533 1.04985 43.1533C0.471362 43.1533 0 43.6273 0 44.209C0 44.7906 0.471362 45.2646 1.04985 45.2646C1.34445 45.2646 1.60692 45.1461 1.79439 44.9522L15.8549 53.1175V70.9293L31.3295 61.9399L31.4634 61.8645V44.6775L46.0006 53.1175V70.9239L60.5914 62.4516C60.72 62.5809 60.886 62.6778 61.0681 62.7263V79.3639L76.6767 88.4233V70.9239L91.7495 79.6709V61.5521L76.9445 52.9613L91.4763 44.5267L106.817 53.4299V35.6181L121.354 27.1782V61.5521L106.415 70.2237L106.281 70.2991V88.4179L120.872 79.9456C121.065 80.1395 121.327 80.258 121.617 80.258C122.195 80.258 122.667 79.784 122.667 79.2023C122.667 78.7122 122.334 78.3028 121.885 78.1843V61.8591L136.824 53.1875L136.957 53.1121V35.9305L151.495 44.3705V60.6957C151.045 60.8142 150.713 61.2236 150.713 61.7137C150.713 61.8107 150.729 61.9022 150.755 61.9884L136.561 70.2291L136.427 70.3045V88.4233L151.768 79.5201L166.841 88.2671L181.914 79.5201L196.986 88.2671L211.791 79.6709V95.6837C211.342 95.8022 211.009 96.2116 211.009 96.7017C211.009 97.2834 211.481 97.7574 212.059 97.7574C212.622 97.7627 213.093 97.2888 213.093 96.7071ZM226.843 87.8039L212.788 95.9638C212.659 95.8345 212.493 95.7376 212.311 95.6891V79.3639L212.579 79.2077L226.848 70.9239V87.8039H226.843ZM197.238 53.4299L211.775 61.8699V78.7445L197.238 70.3045V53.4299ZM212.311 61.8645L226.843 53.4299V70.3045L212.306 78.7445V61.8645H212.311ZM226.843 52.8051L212.306 61.2451V44.3705L226.843 35.9305V52.8051ZM241.937 27.1835V43.3903C241.487 43.5088 241.155 43.9181 241.155 44.4082C241.155 44.4406 241.161 44.4729 241.166 44.5052L227.405 52.4927V35.6235L241.937 27.1835ZM212.332 9.68417L226.87 18.1242V34.9988L212.332 26.5588V9.68417ZM197.238 36.4853C197.42 36.4368 197.586 36.3453 197.715 36.2106L211.77 44.3705V61.2451L197.233 52.8051V36.4853H197.238ZM166.83 52.6489L152.293 44.209L158.897 40.3741L166.83 35.769L181.367 44.209L174.763 48.0438L166.83 52.6489ZM152.025 27.7329C152.207 27.6845 152.373 27.5929 152.502 27.4582L166.289 35.462L152.02 43.7457V27.7329H152.025ZM166.562 34.9934L152.769 26.9843C152.791 26.8981 152.812 26.8065 152.812 26.7096C152.812 26.6126 152.796 26.5211 152.769 26.4349L166.562 18.4258V34.9934ZM166.562 53.1175V69.9921L152.769 61.983C152.791 61.8968 152.812 61.8053 152.812 61.7083C152.812 61.2182 152.48 60.8089 152.03 60.6904V44.6775L166.562 53.1175ZM152.025 62.7317C152.207 62.6832 152.373 62.5863 152.502 62.457L166.289 70.4607L152.02 78.7445V62.7317H152.025ZM181.63 61.5521L167.092 69.9921V53.1175L181.63 44.6775V61.5521ZM182.165 9.37178L196.703 0.931792V17.8064L182.165 26.2464V9.37178ZM181.63 26.8712V43.7457L167.092 35.3058V18.4312L181.63 26.8712ZM166.294 17.9626L152.507 25.9663C152.378 25.837 152.212 25.7401 152.03 25.6916V9.67879L166.294 17.9626ZM136.422 0.937178V17.8118L121.885 26.2518V9.37717L136.422 0.937178ZM91.2085 27.1782V44.0528L76.6713 52.4927V35.6181L91.2085 27.1782ZM61.6038 27.1782L76.141 35.6181V52.4927L68.8724 48.2754L61.6038 44.0581V27.1782ZM76.1357 69.9921L68.8671 65.7748L62.343 61.9884C62.3644 61.9022 62.3858 61.8107 62.3858 61.7137C62.3858 61.2236 62.0537 60.8142 61.6038 60.6957V44.6775L68.8724 48.8948L76.141 53.1121V69.9921H76.1357ZM45.9953 52.4927L31.4634 44.0528V27.1782L46.0006 35.6181V52.4927H45.9953ZM16.3905 18.4312L30.9278 26.8712V43.7457L16.3905 35.3058V18.4312ZM2.06221 43.9343L16.1227 35.7743L30.6599 44.2143L24.0555 48.0438L16.1227 52.6489L2.06221 44.489C2.08363 44.4028 2.10506 44.3113 2.10506 44.2143C2.10506 44.1174 2.08363 44.0258 2.06221 43.9343ZM30.9278 61.5521L16.3905 69.9921V53.1175L30.9278 44.6775V61.5521ZM46.5309 69.9921V53.1175L61.0681 44.6775V60.6904C60.6182 60.8089 60.2861 61.2182 60.2861 61.7083C60.2861 61.8053 60.3022 61.8968 60.329 61.983L46.5309 69.9921ZM76.1357 87.4861L61.5984 79.0461V62.7209C61.7805 62.6724 61.9466 62.5809 62.0751 62.4462L68.8617 66.3888L76.1303 70.6061V87.4861H76.1357ZM91.2085 78.7391L76.6713 70.2991V53.4245L91.2085 61.8645V78.7391ZM106.276 52.4927L91.7442 44.0581V27.1782L106.281 35.6181V52.4927H106.276ZM106.812 34.9988V18.1188L121.349 9.67879V26.5534L106.812 34.9988ZM136.422 18.4366V35.3058L121.885 43.7457V26.8712L136.422 18.4366ZM106.812 87.4915V70.6169L121.349 62.1769V78.1897C120.899 78.3082 120.567 78.7176 120.567 79.2077C120.567 79.3046 120.583 79.3962 120.61 79.4824L106.812 87.4915ZM136.422 52.8051L121.885 61.2451V44.3705L136.422 35.9305V52.8051ZM136.957 18.4312L150.75 26.4349C150.729 26.5211 150.707 26.6126 150.707 26.7096C150.707 27.1997 151.039 27.609 151.489 27.7275V43.7404L136.952 35.3004V18.4312H136.957ZM136.957 70.6169L151.013 62.457C151.141 62.5863 151.307 62.6832 151.489 62.7317V79.0569L136.952 87.4969V70.6169H136.957ZM166.83 87.6477L152.293 79.2077L166.562 70.9239L166.83 70.7677L167.098 70.9239L181.367 79.2077L166.83 87.6477ZM182.433 79.2077L196.97 70.7677L211.508 79.2077L196.97 87.6477L182.433 79.2077Z" fill="white"/>
                </svg>
              
 <?php if($test_block['image_enable'] == 'yes'): ?>
                            <div class="image_box">
                                <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="image" />
                                <svg width="86" height="88" viewBox="0 0 86 88" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M39.9434 87.5484C17.5317 86.8101 0.00666874 66.6886 0.800056 42.6058C1.59344 18.523 20.4048 -0.401485 42.8165 0.336847C65.2281 1.07518 85.8758 32.0772 85.0824 56.16C84.289 80.2429 62.355 88.2868 39.9434 87.5484Z" fill="var(--color-set-one-1)"/>
                                </svg>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($test_block['comments'])): ?>
                            <div class="title_no_a_20 t_comment">
                                <sup>“</sup><?php echo wp_kses($test_block['comments'] , $allowed_tags); ?> <sub>“</sub>
                            </div>
                        <?php endif; ?>
                      
                            <div class="lower_content d-flex  clearfix">
                          
                            <div class="cont">
                                <?php if(!empty($test_block['name'])): ?>
                                    <h4 class="title_no_a_18"><?php echo esc_attr($test_block['name']); ?></h4>
                                <?php endif; ?>
                                <?php if(!empty($test_block['designation'])): ?>
                                    <p><?php echo esc_attr($test_block['designation']); ?></p>
                                <?php endif; ?>
                            </div>
                            <?php if($test_block['rating_enable'] == 'yes'): ?>
                            <div class="rating">
              
                                <p>
                                    <?php if($test_block['rating_one'] == 'one'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                    <?php elseif($test_block['rating_one'] == 'two'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                    <?php elseif($test_block['rating_one'] == 'three'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                    <?php elseif($test_block['rating_one'] == 'four'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i>
                                    <?php elseif($test_block['rating_one'] == 'five'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i>
                                    <?php else: ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i>
                                    <?php endif; ?>
                                </p>
                                <?php if(!empty($test_block['rating_text'])): ?>
                                <p class="rating_text"><?php echo esc_attr($test_block['rating_text']); ?></p>
                                <?php endif; ?>
                              
                            </div>
                            <?php endif; ?>
                        </div>
                        </div>  
                    </div>    
             
                <?php endforeach; ?>
        </div>


 
    </section>

    <?php else: ?>
        <section class="testimonial_ver_carousel nav_false position-relative <?php echo esc_attr($settings['dots_display']); ?>">
            <div class="vertoneitem owl-theme owl-carousel">
                <?php foreach($settings['testi_repeater'] as $test_block):?>
                    <div class="testimonial_box type_one">
                        <svg class="svg1" width="631" height="475" viewBox="0 0 631 475" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M631 382.071L599.611 363.928L630.163 346.265L630.442 346.109V309.8L631 309.476L630.442 309.152V272.854L599.633 255.034L630.197 237.36L630.476 237.204V199.621L598.25 218.256L597.971 218.413V254.074L597.949 254.062V291.008L568.679 307.934C568.411 307.666 568.065 307.465 567.686 307.364V236.567L536.296 218.424V182.126L506.458 164.876C506.513 164.686 506.547 164.497 506.547 164.295C506.547 164.094 506.513 163.904 506.458 163.726L536.018 146.633L536.296 146.476V110.837L566.537 128.322V201.554L596.922 183.981C597.324 184.383 597.87 184.628 598.473 184.628C599.678 184.628 600.659 183.645 600.659 182.439C600.659 181.422 599.968 180.573 599.031 180.327V110.212L630.186 92.1914L630.465 92.0349V54.4523L599.031 72.6292V72.5957L567.083 91.063L535.136 72.5957V109.553L504.059 127.528L503.78 127.685V162.195C502.843 162.441 502.152 163.29 502.152 164.307C502.152 165.323 502.843 166.172 503.78 166.418V200.928L535.17 219.072V254.722L504.896 272.228V236.578L473.518 218.413V217.765L472.96 218.089L472.402 217.765V218.413L441.292 236.4L441.013 236.556V274.139L471.398 256.565C471.8 256.967 472.346 257.213 472.949 257.213C473.551 257.213 474.109 256.967 474.499 256.565L503.769 273.491V346.734L535.716 328.267L566.548 346.086L597.38 363.917L567.106 381.423L566.548 381.099V381.747L565.99 382.071L566.548 382.395V418.693L597.937 436.836V470.699C597 470.945 596.309 471.794 596.309 472.81C596.309 474.017 597.29 475 598.495 475C599.7 475 600.681 474.017 600.681 472.81C600.681 472.609 600.648 472.419 600.592 472.241L630.152 455.147L630.431 454.991V417.408L599.042 435.552V400.55L631 382.071ZM599.086 219.061L629.36 201.554V236.556L599.086 254.062V219.061ZM629.327 345.449L599.053 362.956V327.954L629.327 310.448V345.449ZM629.327 308.504L599.053 290.997V255.995L629.327 273.502V308.504ZM598.506 291.969L628.78 309.476L615.026 317.43L598.506 326.982L569.225 310.057C569.27 309.878 569.314 309.688 569.314 309.487C569.314 309.286 569.281 309.096 569.225 308.917L598.506 291.969ZM566.559 273.513V307.364C566.18 307.465 565.834 307.666 565.566 307.934L551.433 299.756L536.296 291.008V256.006L551.433 264.754L566.559 273.513ZM567.652 128.322L597.926 110.815V145.817L567.652 163.323V128.322ZM567.652 199.621V164.619L597.926 147.113V180.327C596.989 180.573 596.298 181.422 596.298 182.439C596.298 182.64 596.331 182.83 596.387 183.009L567.652 199.621ZM599.086 73.8916L629.36 56.3851V91.387L599.086 108.894V73.8916ZM597.915 109.53L567.641 127.037V92.0349L597.915 74.5284V109.53ZM536.263 74.5284L566.537 92.0349V127.037L536.296 109.553V108.894L536.274 108.905V74.5284H536.263ZM535.17 110.826V145.828L505.9 162.754C505.632 162.486 505.286 162.284 504.907 162.184V128.322L535.17 110.826ZM504.907 200.269V166.407C505.286 166.306 505.632 166.116 505.9 165.837L535.181 182.763V217.765L504.907 200.269ZM566.559 237.215V272.217L551.422 263.469L536.285 254.722V219.72L566.559 237.215ZM442.139 272.217V237.215L472.413 219.709V252.923C471.476 253.169 470.785 254.018 470.785 255.034C470.785 255.236 470.818 255.425 470.874 255.604L442.139 272.217ZM473.518 252.923V219.709L503.792 237.215V272.217L475.068 255.615C475.113 255.437 475.157 255.247 475.157 255.046C475.157 254.018 474.455 253.169 473.518 252.923ZM504.907 273.513L535.181 256.006V291.008L504.907 308.515V273.513ZM504.907 309.8L535.181 292.293V327.295L504.907 344.801V309.8ZM536.285 327.306V292.304L551.422 301.052L565.009 308.906C564.964 309.085 564.919 309.275 564.919 309.476C564.919 310.492 565.611 311.341 566.548 311.587V344.801L536.285 327.306ZM567.675 311.587C568.054 311.487 568.4 311.297 568.667 311.017L597.937 327.943V362.945L567.664 345.438V311.587H567.675ZM597.949 364.889L598.506 364.565L599.064 364.889L628.78 382.071L598.506 399.578L568.232 382.071L597.949 364.889ZM567.675 383.032L597.949 400.539V435.54L567.675 418.034V383.032ZM629.327 419.33V454.332L600.057 471.257C599.789 470.989 599.443 470.788 599.064 470.688V436.825L629.327 419.33ZM443.768 200.593C443.768 200.392 443.735 200.202 443.679 200.023L473.239 182.93L473.518 182.774V110.212L502.609 93.3868C503.011 93.9454 503.658 94.314 504.394 94.314C505.599 94.314 506.58 93.3309 506.58 92.1243C506.58 91.1077 505.889 90.2586 504.952 90.0128V54.4523L473.562 72.5957V36.9458L441.057 18.1545V55.7483L471.856 73.5564L441.571 91.0742L412.289 74.1486C412.334 73.9698 412.379 73.7799 412.379 73.5788C412.379 72.3722 411.397 71.3891 410.192 71.3891C408.988 71.3891 408.006 72.3722 408.006 73.5788C408.006 74.5955 408.698 75.4445 409.635 75.6903V108.905V145.85L378.803 163.681L348.529 146.174L379.082 128.512L379.361 128.355V92.0238L379.918 91.6998L379.361 91.3758V55.7371L410.471 37.7502L410.75 37.5938V0L378.524 18.6349L378.245 18.7913V54.4412L347.971 36.9346V36.2867L347.414 36.6106L315.467 18.1433V53.2904C315.087 53.391 314.741 53.5921 314.474 53.8602L285.204 36.9346V0.011172L253.814 18.1545V18.1433L221.588 36.7782L221.31 36.9346V72.5845L191.036 55.078V54.43L190.478 54.754L189.92 54.43V55.078L159.089 72.8973L127.141 54.43V91.387L96.901 108.882V73.2325L64.4073 54.4412L33.018 36.2867V73.2325L3.74798 90.1581C3.34641 89.7559 2.79983 89.5101 2.18632 89.5101C0.981615 89.5101 0 90.4932 0 91.6998C0 92.9064 0.981615 93.8895 2.18632 93.8895C2.79983 93.8895 3.34641 93.6437 3.73683 93.2415L33.018 110.178V147.124L65.2439 128.478L65.5228 128.322V92.6717L95.7967 110.178V147.113L126.182 129.539C126.45 129.807 126.796 130.009 127.175 130.109V164.619L159.68 183.411V147.113L191.069 165.256V127.674L160.237 109.854L190.5 92.3589L222.447 110.826V73.8804L252.721 56.3739V127.674L221.611 145.661L221.332 145.817V183.4L251.717 165.826C252.119 166.228 252.665 166.474 253.268 166.474C254.473 166.474 255.454 165.491 255.454 164.284C255.454 163.268 254.763 162.419 253.826 162.173V128.31L284.936 110.324L285.215 110.167V74.5284L315.489 92.0349V125.897C314.552 126.143 313.86 126.992 313.86 128.009C313.86 128.21 313.894 128.4 313.949 128.579L284.389 145.672L284.111 145.828V183.411L316.058 164.943L347.447 183.087L378.836 164.943L410.226 183.087L441.057 165.256V198.471C440.12 198.716 439.429 199.565 439.429 200.582C439.429 201.789 440.41 202.772 441.615 202.772C442.786 202.783 443.768 201.8 443.768 200.593ZM472.402 182.126L443.132 199.052C442.865 198.783 442.519 198.582 442.139 198.482V164.619L442.697 164.295L472.413 147.113V182.126H472.402ZM410.75 110.826L441.024 128.333V163.335L410.75 145.828V110.826ZM442.139 128.322L472.402 110.826V145.828L442.128 163.335V128.322H442.139ZM472.402 109.53L442.128 127.037V92.0349L472.402 74.5284V109.53ZM503.836 56.3851V90.0016C502.899 90.2474 502.208 91.0965 502.208 92.1132C502.208 92.1802 502.219 92.2472 502.23 92.3142L473.573 108.882V73.8916L503.836 56.3851ZM442.184 20.0873L472.458 37.5938V72.5957L442.184 55.0891V20.0873ZM410.75 75.6791C411.129 75.5786 411.475 75.3887 411.743 75.1094L441.013 92.0349V127.037L410.739 109.53V75.6791H410.75ZM347.425 109.206L317.151 91.6998L330.905 83.7453L347.425 74.1933L377.699 91.6998L363.945 99.6543L347.425 109.206ZM316.593 57.5246C316.972 57.4241 317.318 57.2342 317.586 56.9549L346.298 73.5564L316.582 90.739V57.5246H316.593ZM346.867 72.5845L318.144 55.9717C318.188 55.793 318.233 55.6031 318.233 55.402C318.233 55.2009 318.199 55.0109 318.144 54.8322L346.867 38.2194V72.5845ZM346.867 110.178V145.18L318.144 128.567C318.188 128.389 318.233 128.199 318.233 127.998C318.233 126.981 317.541 126.132 316.604 125.886V92.6717L346.867 110.178ZM316.593 130.12C316.972 130.02 317.318 129.819 317.586 129.551L346.298 146.152L316.582 163.335V130.12H316.593ZM378.245 127.674L347.971 145.18V110.178L378.245 92.6717V127.674ZM379.361 19.4393L409.635 1.93276V36.9346L379.361 54.4412V19.4393ZM378.245 55.7371V90.739L347.971 73.2325V38.2306L378.245 55.7371ZM346.309 37.2586L317.597 53.8602C317.329 53.5921 316.984 53.391 316.604 53.2904V20.0761L346.309 37.2586ZM284.099 1.94393V36.9458L253.826 54.4523V19.4505L284.099 1.94393ZM189.943 56.3739V91.3758L159.669 108.882V73.8804L189.943 56.3739ZM128.29 56.3739L158.564 73.8804V108.882L143.427 100.135L128.29 91.387V56.3739ZM158.553 145.18L143.416 136.432L129.83 128.579C129.874 128.4 129.919 128.21 129.919 128.009C129.919 126.992 129.227 126.143 128.29 125.897V92.6717L143.427 101.419L158.564 110.167V145.18H158.553ZM95.7856 108.882L65.5228 91.3758V56.3739L95.7967 73.8804V108.882H95.7856ZM34.1334 38.2306L64.4073 55.7371V90.739L34.1334 73.2325V38.2306ZM4.29457 91.13L33.5757 74.2044L63.8496 91.711L50.0958 99.6543L33.5757 109.206L4.29457 92.2807C4.33918 92.102 4.3838 91.912 4.3838 91.711C4.3838 91.5099 4.33918 91.3199 4.29457 91.13ZM64.4073 127.674L34.1334 145.18V110.178L64.4073 92.6717V127.674ZM96.901 145.18V110.178L127.175 92.6717V125.886C126.238 126.132 125.546 126.981 125.546 127.998C125.546 128.199 125.58 128.389 125.636 128.567L96.901 145.18ZM158.553 181.467L128.279 163.96V130.098C128.658 129.997 129.004 129.807 129.272 129.528L143.405 137.706L158.542 146.454V181.467H158.553ZM189.943 163.323L159.669 145.817V110.815L189.943 128.322V163.323ZM221.321 108.882L191.058 91.387V56.3739L221.332 73.8804V108.882H221.321ZM222.436 72.5957V37.5826L252.71 20.0761V55.078L222.436 72.5957ZM284.099 38.2418V73.2325L253.826 90.739V55.7371L284.099 38.2418ZM222.436 181.478V146.476L252.71 128.97V162.184C251.773 162.43 251.081 163.279 251.081 164.295C251.081 164.497 251.115 164.686 251.171 164.865L222.436 181.478ZM284.099 109.53L253.826 127.037V92.0349L284.099 74.5284V109.53ZM285.215 38.2306L313.938 54.8322C313.894 55.0109 313.849 55.2009 313.849 55.402C313.849 56.4186 314.541 57.2677 315.478 57.5135V90.7278L285.204 73.2213V38.2306H285.215ZM285.215 146.476L314.485 129.551C314.753 129.819 315.098 130.02 315.478 130.12V163.983L285.204 181.489V146.476H285.215ZM347.425 181.802L317.151 164.295L346.867 147.113L347.425 146.789L347.983 147.113L377.699 164.295L347.425 181.802ZM379.918 164.295L410.192 146.789L440.466 164.295L410.192 181.802L379.918 164.295Z" fill="white" fill-opacity="0.05"/>
                        </svg>
                        <div class="top_content">
                            <?php if($test_block['rating_enable'] == 'yes'): ?>
                                <p>
                                    <?php if($test_block['rating_one'] == 'one'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                    <?php elseif($test_block['rating_one'] == 'two'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                    <?php elseif($test_block['rating_one'] == 'three'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                    <?php elseif($test_block['rating_one'] == 'four'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i>
                                    <?php elseif($test_block['rating_one'] == 'five'): ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i>
                                    <?php else: ?>
                                        <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i>
                                    <?php endif; ?>
                                </p>
                                <?php endif; ?>
                                <?php if(!empty($test_block['comments'])): ?>
                                <div class="title_no_a_26 t_comment">
                                    <sup>“</sup><?php echo wp_kses($test_block['comments'] , $allowed_tags); ?> <sub>“</sub>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="lower_content clearfix">
                            <?php if($test_block['image_enable'] == 'yes'): ?>
                                <div class="image_box">
                                    <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="image" />
                                    <svg width="86" height="88" viewBox="0 0 86 88" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M39.9434 87.5484C17.5317 86.8101 0.00666874 66.6886 0.800056 42.6058C1.59344 18.523 20.4048 -0.401485 42.8165 0.336847C65.2281 1.07518 85.8758 32.0772 85.0824 56.16C84.289 80.2429 62.355 88.2868 39.9434 87.5484Z" fill="var(--color-set-one-1)"/>
                                    </svg>
                                </div>
                            <?php endif; ?>
                            <div class="cont">
                                <?php if(!empty($test_block['name'])): ?>
                                    <h4 class="title_no_a_22"><?php echo esc_attr($test_block['name']); ?></h4>
                                <?php endif; ?>
                                <?php if(!empty($test_block['designation'])): ?>
                                    <p><?php echo esc_attr($test_block['designation']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <i class="flaticon-right-quote"></i>
                    </div>
                <?php endforeach; ?>
            </div>
    </section>
    <?php endif; ?>
<?php
    }
}

         