<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Team_box_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-team-v1';
    }

    public function get_title()
    {
        return __('Team Box V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('team_settings',
        [ 
            'label' => __('Team Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'team_style',
            [
            'label' => __('Team Styles', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'vankine-addons' ),
                'style_two' => __( 'Style Two', 'vankine-addons' ),
            ],
            'default' => 'style_one' , 
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ], 
            ] 
        );

        $this->add_responsive_control(
            'name',
            [
               'label' => __('Name', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Jacob T. Campbell', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),    
            ]
        );
         
        $this->add_responsive_control(
          'designation',
          [
             'label' => __('Designation', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Junior Manager', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),    
          ]
        );
        $this->add_responsive_control(
            'description',
            [
              'label' => __('Description', 'vankine-addons'),
              'type' => \Elementor\Controls_Manager::TEXTAREA,
              'default' => __('Sit amet consectetur adis
              cing elit. Egestas pharetra dictumst ornare amet', 'vankine-addons'),
              'placeholder' => __('Type your text here', 'vankine-addons'),
            ]
        );
        $this->add_responsive_control(
            'link',
            [
                'label' => __('Link', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'vankine-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );
        $this->add_control(
            'media_enable',
            [
                'label' => __('Media Enable / Disable', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
             
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'media_icon',
        [
            'label' => esc_html__('Media Icon', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('fa-brands fa-facebook' , 'vankine-addons'),
        ]);
       
      
        $repeater->add_responsive_control(
            'media_link',
            [
                'label' => __('Link', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'vankine-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );
        
      
      $this->add_control(
        'media_repeater',
        [
            'label' => __('Media Repeater', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'media_icon' =>  __('fa-brands fa-facebook','vankine-addons'),
                ],
                [
                    'media_icon' =>  __('fa-brands fa-twitter','vankine-addons'),
                ],
                [
                    'media_icon' =>  __('fa-brands fa-skype','vankine-addons'),
                ],
                [
                    'media_icon' =>  __('fa-brands fa-instagram','vankine-addons'),
                ]
                
            ],
            'title_field' => '{{{ media_icon }}}',
            'condition' => [
                'media_enable' => 'yes'
            ],
        ]);
      
     
        $this->end_controls_section();

        $this->start_controls_section('custom_css',
        [ 
            'label' => __('Custom Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
        );
       
        $this->add_control(
            'overlay_color',
             [
                'label' => __(' Overlay Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .image_box .overlay::before  , {{WRAPPER}} .team_box.type_two .image_box .social-icons:before  ' => 'background: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'overlat_text_color',
             [
                'label' => __('Overlay Text Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .image_box .overlay p ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'team_style' => 'style_one'
                ],
             ]
        );
        $this->add_control(
            'overlat_bor_color',
             [
                'label' => __('Overlay Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .image_box .overlay p ' => 'border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'team_style' => 'style_one'
                ],
             ]
        );
        $this->add_control(
            'meida_color',
             [
                'label' => __('Media Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR, 
                'selectors' => [
                    '{{WRAPPER}} .social-icons ul li .m_icon ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
         
        $this->add_control(
            'media_bg_color',
             [
                'label' => __('Media Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icons ul li .m_icon ' => 'background: {{VALUE}}!important;',
                ],
             ]
        );
 
        $this->add_control(
            'title_color',
             [
                'label' => __('Title Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .team_box.type_one  .title_20 a  , {{WRAPPER}}  .team_box.type_two  .title_22 a ,
                    {{WRAPPER}}  .team_box.type_one  .title_20 a span:after  , {{WRAPPER}}  .team_box.type_two  .title_22  a span:after  ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_control(
            'content_color',
             [
                'label' => __('Content Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .contnet p , {{WRAPPER}} .team_box.type_two .contnet p ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        
      
        $this->add_control(
            'link_color',
             [
                'label' => __('Link Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .contnet .link svg path ' => 'stroke: {{VALUE}}!important;',
                ],
                'condition' => [
                    'team_style' => 'style_one'
                ],
             ]
        );

        $this->add_control(
            'link_bg_color',
             [
                'label' => __('Link Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_one .contnet .link ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'team_style' => 'style_one'
                ],
             ]
        );


        $this->add_control(
            'box_bg_color',
             [
                'label' => __('Box Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_two .team_box_inner:before ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'team_style' => 'style_two'
                ],
             ]
        );

        
        $this->add_control(
            'hobox_bg_color',
             [
                'label' => __('Hover Box Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_two:hover .team_box_inner:before ' => 'background: {{VALUE}}!important;',
                ],
                'condition' => [
                    'team_style' => 'style_two'
                ],
             ]
        );
      

          
        $this->add_control(
            'hobox_tit_color',
             [
                'label' => __('Hover Title Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team_box.type_two:hover .contnet h6 a , {{WRAPPER}} .team_box.type_two:hover .contnet h6 a span:after ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'team_style' => 'style_two'
                ],
             ]
        );
      

          
        $this->add_control(
            'hobox_con_color',
             [
                'label' => __('Hover Cotent Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .team_box.type_two:hover .contnet p  ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'team_style' => 'style_two'
                ],
             ]
        );
      

        
  
    $this->end_controls_section();


    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        $target = $settings['link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['link']['nofollow'] ? ' rel="nofollow"' : '';
    ?>
    <?php // style ?>
    <?php if($settings['team_style'] == 'style_one'):  ?>
    <?php // style ?>
        <div class="team_box type_one">
        <?php if(!empty($settings['image']['url'])): ?>
            <div class="image_box">
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                <div class="overlay trans">
                    <?php if(!empty($settings['description'])): ?>
                        <p> <?php echo wp_kses($settings['description'] , $allowed_tags);  ?></p>
                    <?php endif; ?>
                    <?php if($settings['media_enable'] == 'yes'): ?>
                        <div class="social-icons">
                            <ul>
                                <?php foreach($settings['media_repeater'] as $media):
                                    $mtarget = $media['media_link']['is_external'] ? ' target="_blank"' : '';
                                    $mnofollow = $media['media_link']['nofollow'] ? ' rel="nofollow"' : '';
                                    ?>
                                    <li><a href="<?php echo esc_url($media['media_link']['url']); ?>"  class="m_icon" <?php echo esc_attr($mtarget); ?> <?php echo esc_attr($mnofollow); ?>>
                                        <i class="<?php echo esc_attr($media['media_icon']); ?>"></i>
                                    </a></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
            <div class="contnet">
            <?php if(!empty($settings['name'])): ?>
                <h6 class="title_22"> 
                    <a href="<?php echo esc_url($settings['link']['url']); ?>" <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                        <?php echo wp_kses($settings['name'] , $allowed_tags); ?>
                    </a>
                </h6>
                <?php endif; ?>
                <?php if(!empty($settings['designation'])): ?>
                    <p> <?php echo wp_kses($settings['designation'] , $allowed_tags); ?></p>
                <?php endif; ?>
                <?php if(!empty($settings['link']['url'])): ?>
                <a class="link trans" href="<?php echo esc_attr($settings['link']['url']); ?>" <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg" class="trans">
                        <path class="trans" d="M1 12.25L12.25 1M12.25 1H3.8125M12.25 1V9.4375" stroke="#2D947A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                    </svg>                   
                </a>
                <?php endif; ?>
            </div>
        </div>
        <?php // style ?>
    <?php elseif($settings['team_style'] == 'style_two'):  ?>
    <?php // style ?>
        <div class="team_box type_two">
            <div class="team_box_inner">
         <div class="contnet">
                <?php if(!empty($settings['name'])): ?>
                    <h6 class="title_22"> 
                        <a href="<?php echo esc_url($settings['link']['url']); ?>" <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                            <?php echo wp_kses($settings['name'] , $allowed_tags); ?>
                        </a>
                    </h6>
                <?php endif; ?>
                <?php if(!empty($settings['designation'])): ?>
                    <p> <?php echo wp_kses($settings['designation'] , $allowed_tags); ?></p>
                <?php endif; ?>
                <?php if(!empty($settings['description'])): ?>
                    <p> <?php echo wp_kses($settings['description'] , $allowed_tags); ?></p>
                <?php endif; ?>
            </div>
            <?php if(!empty($settings['image']['url'])): ?>
            <div class="image_box">
                <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                <?php if($settings['media_enable'] == 'yes'): ?>
                    <div class="social-icons trans">
                    <ul>
                    <?php foreach($settings['media_repeater'] as $media):
                        $mtarget = $media['media_link']['is_external'] ? ' target="_blank"' : '';
                        $mnofollow = $media['media_link']['nofollow'] ? ' rel="nofollow"' : '';
                        ?>
                        <li>
                            <a href="<?php echo esc_url($media['media_link']['url']); ?>"  class="m_icon" <?php echo esc_attr($mtarget); ?> <?php echo esc_attr($mnofollow); ?>>
                                <i class="<?php echo esc_attr($media['media_icon']); ?>"></i>
                            </a>
                        </li>
                    <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            </div>
        </div>
    <?php // style ?>
    <?php endif; ?>
    <?php // style ?>


    <?php
    }
}

 

