<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Process_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-process-v1';
    }

    public function get_title()
    {
        return __('Process V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('process_settings',
        [ 
            'label' => __('Process Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'process_style',
            [
            'label' => __('Process Styles', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'vankine-addons' ),
                'style_two' => __( 'Style Two', 'vankine-addons' ),
                'style_three' => __( 'Style Three', 'vankine-addons' ),
                'style_four' => __( 'Style Four', 'vankine-addons' ),
            ],
            'default' => 'style_one' , 
            ]
        );

        $this->add_control(
            'fmage',
            [
                'label' => __( 'Featured Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'process_style' => ['style_one' , 'style_two' ,'style_three']
                ],
            ] 
        );

        $this->add_responsive_control(
            'step_count',
            [
               'label' => __('Steps', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Step 01', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),    
            ]
          );
    
        $this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'vankine-addons' ),
					'icon'  => esc_html__( 'Icon', 'vankine-addons' ), 
				], 
                'default' => 'icon' , 
			]
		);
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );
        $this->add_control(
            'switcher_c_icon',
            [
                'label' => esc_html__( 'Use Custom Icon', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'icon_type' => 'icon'
                ],
            ]
        );
        
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => vankine_get_icon(),
                'default' => 'fi-rs-user' , 
                'condition' => [
                    'switcher_c_icon' => 'yes' ,
                    'icon_type' => 'icon'
                ]
            ]
        );
        $this->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [
                    'switcher_c_icon' => '',
                    'icon_type' => 'icon'
                ]
            ]
        );
        
   
        $this->add_responsive_control(
          'titles',
          [
             'label' => __('Title', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Choose Insurance', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),    
          ]
        );
  
       
        $this->add_responsive_control(
            'content',
            [
               'label' => __('Content', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Sed ut perspiciatis unde omnis 
               este natus voluptatem accusantium doloremque laudante aperis', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),   
               
            ]
        );
        $this->add_control(
            'link_enable',
            [
                'label' => __('Link Enable / Disable', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
               
            ]
        );
        $this->add_responsive_control(
            'button_text',
            [
              'label' => __('Button Label', 'vankine-addons'),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => __('Read More', 'vankine-addons'),
              'placeholder' => __('Type your Symbols here', 'vankine-addons'),
              'condition' => [
                'link_enable' => 'yes' , 
                'process_style' => 'style_one' ,
               ], 
            ]
        );
        $this->add_responsive_control(
            'button_link',
            [
                'label' => __('Link', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'vankine-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
               
            ]
        );
        $this->add_control(
            'arrow_enable',
            [
                'label' => esc_html__( 'Arrow Enable / Disable', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'process_style' => 'style_four'
                ],
            ]
        );
        
       

    $this->end_controls_section();

    $this->start_controls_section('process_css',
    [ 
        'label' => __('Process Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'arrow_color',
         [
            'label' => __('Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_four .icon svg path ' => 'fill: {{VALUE}}!important;  opacity:1!important;',
            ],
            'condition' => [
                'arrow_enable' => 'yes'
            ],
         ]
    );
    $this->add_control(
        'arrow_hocer_color',
         [
            'label' => __('Arrow Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_four:hover .icon svg path ' => 'fill: {{VALUE}}!important; opacity:1!important;',
            ],
            'condition' => [
                'arrow_enable' => 'yes'
            ],
         ]
    );
    $this->add_control(
        'stpcolor',
         [
            'label' => __('Step Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_one .image_box p , {{WRAPPER}}  .process_box.type_two .content .step , {{WRAPPER}} .process_box.type_three .content_no .con_top p , {{WRAPPER}} .process_box.type_four .icon .step ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'stpbgcolor',
         [
            'label' => __('Step Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_one .image_box p , {{WRAPPER}}  .process_box.type_two .content .step , {{WRAPPER}} .process_box.type_three .content_no .con_top p , {{WRAPPER}} .process_box.type_four .icon .step ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'iconbgcolor',
         [
            'label' => __('Icon Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_one .content .icon , {{WRAPPER}} .process_box.type_four .icon   ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'process_style' => ['style_one' , 'style_four'] , 
            ], 
         ]
    );

    $this->add_control(
        'iconcolor',
         [
            'label' => __('Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_one .content .icon i , {{WRAPPER}} .process_box.type_two .icon i , {{WRAPPER}} .process_box.type_four .icon i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    
    $this->add_control(
        'titlecolor',
         [
            'label' => __('Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box .title_22 a , {{WRAPPER}} .process_box .title_22 a span:after , {{WRAPPER}} .process_box .title_20 a , {{WRAPPER}} .process_box .title_20 a span:after ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'titlebgcolor',
         [
            'label' => __('Title Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_three .content_no .con_top .title_22 ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'process_style' => 'style_three' , 
            ], 
         ]
    );

    $this->add_control(
        'bordercolor',
         [
            'label' => __('Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_one .content .border_bg:before ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'process_style' => 'style_one' , 
            ], 
         ]
    );
    
    $this->add_control(
        'descolor',
         [
            'label' => __('Description Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box .content p , {{WRAPPER}} .process_box.type_three .content_no p , {{WRAPPER}} .process_box.type_four .content_no p ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'rdcolor',
         [
            'label' => __('Readmore  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box .content .rd_more ' => 'color: {{VALUE}}!important;',
            ],
            'condition' => [
                'process_style' => ['style_one' , 'style_two'] , 
            ], 
         ]
    );
    
    $this->add_control(
        'rdbgcolor',
         [
            'label' => __('Readmore Bg  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_two .content .rd_more ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'process_style' => ['style_one' , 'style_two'] , 
            ], 
         ]
    );
    $this->add_control(
        'rdbghocolor',
         [
            'label' => __('Readmore Bg  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_two:hover .content .rd_more ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'process_style' => 'style_two' , 
            ], 
         ]
    );

    $this->add_control(
        'overlaycolor',
         [
            'label' => __('Overlay Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_two .hover_1 .oh ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'process_style' => ['style_two' , 'style_three'] , 
            ], 
         ]
    );
    $this->add_control(
        'overlaytwocolor',
         [
            'label' => __('Overlay Gradient Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_two .image_box:before ' => 'background-image: linear-gradient(to bottom, rgba(0, 0, 0, 0), {{VALUE}})!important;',
            ],
            'condition' => [
                'process_style' => ['style_two'] , 
            ], 
         ]
    );

    $this->add_control(
        'conte_border_color',
         [
            'label' => __('Contet Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_four .content_no ' => 'border-color:{{VALUE}}!important;',
            ],
            'condition' => [
                'process_style' => ['style_four'] , 
            ], 
         ]
    );

    $this->add_control(
        'conte_bg_color',
         [
            'label' => __('Contet Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .process_box.type_four .content_no ' => 'background:{{VALUE}}!important;',
            ],
            'condition' => [
                'process_style' => ['style_four'] , 
            ], 
         ]
    );
    
    

    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : '';
     ?>
        
    <?php // style ?>
    <?php if($settings['process_style'] == 'style_one'):  ?>
    <?php // style ?>

    <div class="process_box  type_one">
             <?php if(!empty($settings['fmage']['url'])): ?>
                    <div class="image_box">
                        <img src="<?php echo esc_url($settings['fmage']['url']); ?>" alt="img" />
                        <?php if(!empty($settings['step_count'])): ?>
                            <p><?php echo wp_kses($settings['step_count'] , $allowed_tags); ?></p>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <div class="content">
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon trans">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <div class="icon trans">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                            </div>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon trans">
                                <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                        <?php endif; ?>	
                    <?php endif; ?>	
            <?php endif; ?>
            <?php if(!empty($settings['titles'])): ?>
                <div class="title_22">
                    <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                        <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
            <?php endif; ?>
                <div class="border_bg"></div>
            <?php if($settings['link_enable'] == 'yes'): if(!empty($settings['button_text'])): ?>
                <a class="rd_more" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <?php echo esc_html($settings['button_text']);?><i class="icontb fi-rs-arrow-small-right"></i>
                </a> 
            <?php endif; endif; ?>
    </div>  
    </div>
    <?php // style ?>
    <?php elseif($settings['process_style'] == 'style_two'):  ?>
    <?php // style ?>

    <div class="process_box  type_two hover_1_get">
        <?php if(!empty($settings['fmage']['url'])): ?>
            <div class="image_box hover_1">
                <img src="<?php echo esc_url($settings['fmage']['url']); ?>" alt="img" />
                <div class="oh ho_1"></div>
                <div class="oh ho_2"></div>
                <div class="oh ho_3"></div>
                <div class="oh ho_4"></div>
                <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon trans">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
         <?php endif; ?>
        <?php elseif($settings['icon_type'] == 'icon'): ?>
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <div class="icon trans">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                            </div>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon trans">
                                <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                        <?php endif; ?>	
                    <?php endif; ?>	
            <?php endif; ?>
            </div>
        <?php endif; ?>
     
        <div class="content">
            <?php if($settings['link_enable'] == 'yes'): ?>
                <a class="rd_more trans" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M5.60161 0H19.6641C19.9128 0 20.1512 0.0987719 20.327 0.274587C20.5028 0.450403 20.6016 0.68886 20.6016 0.9375V15C20.6016 15.2486 20.5028 15.4871 20.327 15.6629C20.1512 15.8387 19.9128 15.9375 19.6641 15.9375C19.4155 15.9375 19.177 15.8387 19.0012 15.6629C18.8254 15.4871 18.7266 15.2486 18.7266 15V3.2L1.57661 20.35C1.3989 20.5156 1.16384 20.6058 0.920961 20.6015C0.678085 20.5972 0.446354 20.4988 0.274588 20.327C0.102821 20.1553 0.00443133 19.9235 0.000146059 19.6807C-0.00413921 19.4378 0.0860148 19.2027 0.251615 19.025L17.4016 1.875H5.60161C5.35297 1.875 5.11452 1.77623 4.9387 1.60041C4.76289 1.4246 4.66411 1.18614 4.66411 0.9375C4.66411 0.68886 4.76289 0.450403 4.9387 0.274587C5.11452 0.0987719 5.35297 0 5.60161 0Z" fill="white"/>
                    </svg>
                </a> 
            <?php endif;  ?>
            <?php if(!empty($settings['titles'])): ?>
                <div class="title_22">
                    <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                        <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
            <?php endif; ?>
            <?php if(!empty($settings['step_count'])): ?>
                <p class="step"><?php echo wp_kses($settings['step_count'] , $allowed_tags); ?></p>
            <?php endif; ?>
        </div>
    </div>
    <?php // style ?>
    <?php elseif($settings['process_style'] == 'style_three'):  ?>
    <?php // style ?>

    <div class="process_box type_two type_three hover_1_get">
        <?php if(!empty($settings['fmage']['url'])): ?>
            <div class="image_box hover_1">
                <img src="<?php echo esc_url($settings['fmage']['url']); ?>" alt="img" />
                <div class="oh ho_1"></div>
                <div class="oh ho_2"></div>
                <div class="oh ho_3"></div>
                <div class="oh ho_4"></div>
                <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon trans">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
         <?php endif; ?>
        <?php elseif($settings['icon_type'] == 'icon'): ?>
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <div class="icon trans">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                            </div>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon trans">
                                <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                        <?php endif; ?>	
                    <?php endif; ?>	
            <?php endif; ?>
            </div>
        <?php endif; ?>
        <div class="content_no">
                <div class="con_top">
                    <?php if(!empty($settings['step_count'])): ?>
                        <p class="step"><?php echo wp_kses($settings['step_count'] , $allowed_tags); ?></p>
                    <?php endif; ?>
                    <?php if(!empty($settings['titles'])): ?>
                    <div class="title_22">
                        <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            <?php if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
            <?php endif; ?>
           
        </div>
    </div>


    <?php // style ?>
    <?php elseif($settings['process_style'] == 'style_four'):  ?>
    <?php // style ?>
    <div class="process_box type_four">
     <?php if($settings['icon_type'] == 'image'): ?>
            <?php if(!empty($settings['image']['url'])): ?>
                <div class="icon trans">
                    <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    <?php if(!empty($settings['step_count'])): ?>
                        <p class="step"><?php echo wp_kses($settings['step_count'] , $allowed_tags); ?></p>
                    <?php endif; ?>
                    <?php if($settings['arrow_enable'] == 'yes'): ?>
                    <svg width="123" height="16" viewBox="0 0 123 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.2" d="M122.354 8.35355C122.549 8.15829 122.549 7.84171 122.354 7.64645L119.172 4.46447C118.976 4.2692 118.66 4.2692 118.464 4.46447C118.269 4.65973 118.269 4.97631 118.464 5.17157L121.293 8L118.464 10.8284C118.269 11.0237 118.269 11.3403 118.464 11.5355C118.66 11.7308 118.976 11.7308 119.172 11.5355L122.354 8.35355ZM0 8.5H3.05V7.5H0V8.5ZM9.15 8.5H15.25V7.5H9.15V8.5ZM21.35 8.5H27.45V7.5H21.35V8.5ZM33.55 8.5H39.65V7.5H33.55V8.5ZM45.75 8.5H51.85V7.5H45.75V8.5ZM57.95 8.5H64.05V7.5H57.95V8.5ZM70.15 8.5H76.25V7.5H70.15V8.5ZM82.35 8.5H88.45V7.5H82.35V8.5ZM94.55 8.5H100.65V7.5H94.55V8.5ZM106.75 8.5H112.85V7.5H106.75V8.5ZM118.95 8.5H122V7.5H118.95V8.5ZM122.707 8.70711C123.098 8.31658 123.098 7.68342 122.707 7.29289L116.343 0.928932C115.953 0.538408 115.319 0.538408 114.929 0.928932C114.538 1.31946 114.538 1.95262 114.929 2.34315L120.586 8L114.929 13.6569C114.538 14.0474 114.538 14.6805 114.929 15.0711C115.319 15.4616 115.953 15.4616 116.343 15.0711L122.707 8.70711ZM0 9H3.05V7H0V9ZM9.15 9H15.25V7H9.15V9ZM21.35 9H27.45V7H21.35V9ZM33.55 9H39.65V7H33.55V9ZM45.75 9H51.85V7H45.75V9ZM57.95 9H64.05V7H57.95V9ZM70.15 9H76.25V7H70.15V9ZM82.35 9H88.45V7H82.35V9ZM94.55 9H100.65V7H94.55V9ZM106.75 9H112.85V7H106.75V9ZM118.95 9H122V7H118.95V9Z" fill="#181818"/>
                    </svg>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        <?php elseif($settings['icon_type'] == 'icon'): ?>
            <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                <?php if(!empty($settings['icon'])): ?>
                 <div class="icon trans">
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                    <?php if(!empty($settings['step_count'])): ?>
                        <p class="step"><?php echo wp_kses($settings['step_count'] , $allowed_tags); ?></p>
                    <?php endif; ?>
                    <?php if($settings['arrow_enable'] == 'yes'): ?>
                    <svg width="123" height="16" viewBox="0 0 123 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.2" d="M122.354 8.35355C122.549 8.15829 122.549 7.84171 122.354 7.64645L119.172 4.46447C118.976 4.2692 118.66 4.2692 118.464 4.46447C118.269 4.65973 118.269 4.97631 118.464 5.17157L121.293 8L118.464 10.8284C118.269 11.0237 118.269 11.3403 118.464 11.5355C118.66 11.7308 118.976 11.7308 119.172 11.5355L122.354 8.35355ZM0 8.5H3.05V7.5H0V8.5ZM9.15 8.5H15.25V7.5H9.15V8.5ZM21.35 8.5H27.45V7.5H21.35V8.5ZM33.55 8.5H39.65V7.5H33.55V8.5ZM45.75 8.5H51.85V7.5H45.75V8.5ZM57.95 8.5H64.05V7.5H57.95V8.5ZM70.15 8.5H76.25V7.5H70.15V8.5ZM82.35 8.5H88.45V7.5H82.35V8.5ZM94.55 8.5H100.65V7.5H94.55V8.5ZM106.75 8.5H112.85V7.5H106.75V8.5ZM118.95 8.5H122V7.5H118.95V8.5ZM122.707 8.70711C123.098 8.31658 123.098 7.68342 122.707 7.29289L116.343 0.928932C115.953 0.538408 115.319 0.538408 114.929 0.928932C114.538 1.31946 114.538 1.95262 114.929 2.34315L120.586 8L114.929 13.6569C114.538 14.0474 114.538 14.6805 114.929 15.0711C115.319 15.4616 115.953 15.4616 116.343 15.0711L122.707 8.70711ZM0 9H3.05V7H0V9ZM9.15 9H15.25V7H9.15V9ZM21.35 9H27.45V7H21.35V9ZM33.55 9H39.65V7H33.55V9ZM45.75 9H51.85V7H45.75V9ZM57.95 9H64.05V7H57.95V9ZM70.15 9H76.25V7H70.15V9ZM82.35 9H88.45V7H82.35V9ZM94.55 9H100.65V7H94.55V9ZM106.75 9H112.85V7H106.75V9ZM118.95 9H122V7H118.95V9Z" fill="#181818"/>
                    </svg>
                    <?php endif; ?>
                </div>
            <?php endif; ?>	
            <?php else: ?>
            <?php if(!empty($settings['icon_lib'])): ?>
                <div class="icon trans">
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                    <?php if(!empty($settings['step_count'])): ?>
                        <p class="step"><?php echo wp_kses($settings['step_count'] , $allowed_tags); ?></p>
                    <?php endif; ?>
                    <?php if($settings['arrow_enable'] == 'yes'): ?>
                    <svg width="123" height="16" viewBox="0 0 123 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.2" d="M122.354 8.35355C122.549 8.15829 122.549 7.84171 122.354 7.64645L119.172 4.46447C118.976 4.2692 118.66 4.2692 118.464 4.46447C118.269 4.65973 118.269 4.97631 118.464 5.17157L121.293 8L118.464 10.8284C118.269 11.0237 118.269 11.3403 118.464 11.5355C118.66 11.7308 118.976 11.7308 119.172 11.5355L122.354 8.35355ZM0 8.5H3.05V7.5H0V8.5ZM9.15 8.5H15.25V7.5H9.15V8.5ZM21.35 8.5H27.45V7.5H21.35V8.5ZM33.55 8.5H39.65V7.5H33.55V8.5ZM45.75 8.5H51.85V7.5H45.75V8.5ZM57.95 8.5H64.05V7.5H57.95V8.5ZM70.15 8.5H76.25V7.5H70.15V8.5ZM82.35 8.5H88.45V7.5H82.35V8.5ZM94.55 8.5H100.65V7.5H94.55V8.5ZM106.75 8.5H112.85V7.5H106.75V8.5ZM118.95 8.5H122V7.5H118.95V8.5ZM122.707 8.70711C123.098 8.31658 123.098 7.68342 122.707 7.29289L116.343 0.928932C115.953 0.538408 115.319 0.538408 114.929 0.928932C114.538 1.31946 114.538 1.95262 114.929 2.34315L120.586 8L114.929 13.6569C114.538 14.0474 114.538 14.6805 114.929 15.0711C115.319 15.4616 115.953 15.4616 116.343 15.0711L122.707 8.70711ZM0 9H3.05V7H0V9ZM9.15 9H15.25V7H9.15V9ZM21.35 9H27.45V7H21.35V9ZM33.55 9H39.65V7H33.55V9ZM45.75 9H51.85V7H45.75V9ZM57.95 9H64.05V7H57.95V9ZM70.15 9H76.25V7H70.15V9ZM82.35 9H88.45V7H82.35V9ZM94.55 9H100.65V7H94.55V9ZM106.75 9H112.85V7H106.75V9ZM118.95 9H122V7H118.95V9Z" fill="#181818"/>
                    </svg>
                    <?php endif; ?>
                </div>
            <?php endif; ?>	
        <?php endif; ?>	
    <?php endif; ?>
    <div class="content_no">

        <div class="con_top">
        <?php if(!empty($settings['titles'])): ?>
            <div class="title_20">
                <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                    <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                </a>
            </div>
        <?php endif; ?>
        <?php if(!empty($settings['content'])): ?>
            <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
        <?php endif; ?>
        </div>   
    </div>
</div>
<?php // style ?>
<?php endif; ?>
<?php // style ?>


    <?php
    }
}

 

