<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Icon_box extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-icon-v1';
    }

    public function get_title()
    {
        return __('Icon Box With Content V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('icon_content_v1_settings',
        [ 
            'label' => __('Icon Box Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'icon_box_style',
            [
            'label' => __('Icon Box Styles', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'vankine-addons' ),
                'style_two' => __( 'Style Two', 'vankine-addons' ),
                'style_three' => __( 'Style Three', 'vankine-addons' ),
                'style_four' => __( 'Style Four', 'vankine-addons' ),
                'style_five' => __( 'Style Five', 'vankine-addons' ),
                'style_six' => __( 'Style Six', 'vankine-addons' ),
                'style_seven' => __( 'Style Seven', 'vankine-addons' ),
            ],
            'default' => 'style_one' , 
            ]
        );

        $this->add_control(
            'display_inline',
            [
                'label' => esc_html__( 'Display Inline', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'icon_box_style' => 'style_four'
                ],
            ]
        );
        
       
        $this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'vankine-addons' ),
					'icon'  => esc_html__( 'Icon', 'vankine-addons' ), 
				], 
                'default' => 'icon' , 
			]
		);
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );

        $this->add_control(
            'switcher_c_icon',
            [
                'label' => esc_html__( 'Use Custom Icon', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'icon_type' => 'icon'
                ],
            ]
        );
        
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => vankine_get_icon(),
                'default' => 'fi-rs-user' , 
                'condition' => [
                    'switcher_c_icon' => 'yes' ,
                    'icon_type' => 'icon'
                ]
            ]
        );
        $this->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [
                    'switcher_c_icon' => '',
                    'icon_type' => 'icon'
                ]
            ]
        );
          
        $this->add_control(
            'shape_enable',
            [
                'label' => __('Shape Enable / Disable', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'icon_box_style' => 'style_one'
                ],
            ]
        );

        $this->add_responsive_control(
          'titles',
          [
             'label' => __('Title', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Professional Insurance Services', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),    
          ]
        );
  
        $this->add_control(
            'content_enable',
            [
                'label' => __('Content Enable / Disable', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'icon_box_style' => ['style_one' , 'style_two' , 'style_three' , 'style_five' , 'style_six' , 'style_seven']
                ],
            ]
        );
        $this->add_responsive_control(
            'content',
            [
               'label' => __('Content', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Sit amet conset adiscin elites', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),   
                'condition' => [
                    'content_enable' => 'yes' ,
                    'icon_box_style' => ['style_one' , 'style_two' , 'style_three' , 'style_five' , 'style_six' , 'style_seven']
                ],
            ]
        );
        $this->add_control(
            'link_enable',
            [
                'label' => __('Link Enable / Disable', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
               
            ]
        );
        $this->add_responsive_control(
            'button_text',
            [
              'label' => __('Button Label', 'vankine-addons'),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => __('Read More', 'vankine-addons'),
              'placeholder' => __('Type your Symbols here', 'vankine-addons'),
               'condition' => [
                    'link_enable' => 'yes' ,
                    'icon_box_style' => ['style_one' , 'style_two' , 'style_three' , 'style_five' , 'style_seven']
               ],
            ]
        );
        $this->add_responsive_control(
            'button_link',
            [
                'label' => __('Link', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'vankine-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                
            ]
        );


        $this->add_control(
            'box_show_enable',
            [
                'label' => __('Box Shadow Enable / Disable', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'icon_box_style' => ['style_seven']
                ],
            ]
        );
       

    $this->end_controls_section();

    $this->start_controls_section('icon_css',
    [ 
        'label' => __('Icon Box Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'cssone',
         [
            'label' => __('Icon Box Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only.type_one .icon_box_in , {{WRAPPER}} .icon_box_only.type_three .icon_inner , {{WRAPPER}} .icon_box_only.type_four 
                , {{WRAPPER}} .icon_box_only.type_seven , {{WRAPPER}} .icon_box_only.type_six' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_one' , 'style_two' , 'style_three' , 'style_four' , 'style_six' , 'style_seven']
            ],
         ]
    );
    $this->add_control(
        'cssonbr',
         [
            'label' => __('Icon Box Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only.type_seven ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_seven']
            ],
         ]
    );
    $this->add_control(
        'cssonbhor',
         [
            'label' => __('Icon Box Border Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only.type_seven:hover ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_seven']
            ],
         ]
    );
    $this->add_control(
        'cssonebg',
         [
            'label' => __('Icon Box Bg Color Two', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only.type_three:before ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_three']
            ],
         ]
    );
    $this->add_control(
        'csstwo',
         [
            'label' => __('Icon Box svg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only.type_one .icon_box_in .shape_image svg path' => 'fill: {{VALUE}}!important;',
                '{{WRAPPER}} .icon_box_only.type_four .link  svg circle' => 'fill: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_one' , 'style_four']
            ],
         ]
    );
    $this->add_control(
        'cssthree',
         [
            'label' => __('Icon Box svg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only.type_one .icon_box_in .shape_image svg path.two' => 'fill: {{VALUE}}!important;',
                '{{WRAPPER}} .icon_box_only.type_four .link  svg g path' => 'fill: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_one' , 'style_four']
            ],
         ]
    );
    $this->add_control(
        'csstfioour',
         [
            'label' => __('Icon  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon i' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'csstfioourbg',
         [
            'label' => __('Icon Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}   .icon_box_only .icon  ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_three' , 'style_seven' , 'style_six']
            ],
         ]
    );

    $this->add_control(
        'icon_br_color',
         [
            'label' => __('Icon Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only.type_six .icon ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_six']
            ],
         ]
    );
    $this->add_responsive_control(
        'icon_br_radius',
        [
            'label' => __( 'Button Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px'],
            'selectors' => [
                '{{WRAPPER}} .icon_box_only.type_six .icon ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_six']
            ],
        ]
    );
  

  
    $this->add_responsive_control(
        'icon_top',
        [
            'label' => __('Icon Move Top', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 0,
            'min'     => 1,
            'max'     => 150,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only .icon i ' => 'top: {{VALUE}}px!important; position:relative;', 
            ],
            'condition' => [
                'icon_box_style' => ['style_five']
            ],
        ]
    );
    $this->add_control(
        'cssfive',
         [
            'label' => __('Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only  .title_22 a , {{WRAPPER}} .icon_box_only  .title_18 a , {{WRAPPER}} .icon_box_only  .title_18 a span:after , {{WRAPPER}} .icon_box_only  .title_22 a span:after ,
                {{WRAPPER}} .icon_box_only  .title_24 a  , {{WRAPPER}} .icon_box_only  .title_24 a span:after' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'cssfiveho',
         [
            'label' => __('Title Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only:hover  .title_22 a , {{WRAPPER}} .icon_box_only:hover  .title_22 a span:after , {{WRAPPER}} .icon_box_only:hover .title_18 a , {{WRAPPER}} .icon_box_only:hover .title_18 a span:after ,
                {{WRAPPER}} .icon_box_only:hover  .title_24 a , {{WRAPPER}} .icon_box_only:hover  .title_24 a span:after' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'css_six',
         [
            'label' => __('Description Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only  p ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'css_seven',
         [
            'label' => __('Read More Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .icon_box_only  .rd_more , {{WRAPPER}} .icon_box_only  .rd_more i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
 
    
    $this->add_control(
        'hover_bg',
         [
            'label' => __('Hover Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}   .icon_box_only.type_one .icon_box_in:hover .after , {{WRAPPER}} .icon_box_only.type_three:hover:before ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_one']
            ],
         ]
    ); 
    $this->add_control(
        'hover_bor',
         [
            'label' => __('Hover Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .icon_box_only.type_seven:hovere ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'icon_box_style' => ['style_three']
            ],
         ]
    );
    
    

    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : '';
     ?>
        
    <?php // style ?>
    <?php if($settings['icon_box_style'] == 'style_one'):  ?>
    <?php // style ?>

    <div class="icon_box_only  type_one">
        <div class="icon_box_in trans">
        <?php if($settings['shape_enable'] == 'yes'): ?>
            <?php  global $vankine_theme_mod;
                $rtl_enable = isset( $vankine_theme_mod['rtl_enable'] ) ? $vankine_theme_mod['rtl_enable'] : '';
              if(is_rtl() || $rtl_enable == true){ ?>
                <div class="shape_image rtl">
                    <svg width="116" height="121" viewBox="0 0 116 121" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M96.6946 39.6223L116 0H99L80.3268 36.0124L96.6946 39.6223Z" fill="var(--color-set-one-1)"/>
                        <path d="M79.6784 44.7789L96.6914 39.6339L75.1435 29.0508L58.0171 34.1875L79.6784 44.7789Z" fill="var(--color-set-one-2)"/>
                        <path d="M41.1296 66.1668L58.4062 61.0318L35.5066 52.772L18.3802 57.9087L41.1296 66.1668Z" fill="var(--color-set-one-2)"/>
                        <path d="M75.1436 29.0508L58.4064 61.0319L45.0654 56.223L56.1474 34.7522L75.1436 29.0508Z" fill="var(--color-set-one-1)"/>
                        <path d="M35.5376 52.792L0.500053 121V91.5L16.5414 58.4917" fill="var(--color-set-one-1)"/>
                    </svg>
                </div>
                <?php } else{ ?>
                <div class="shape_image">
                <svg width="116" height="121" viewBox="0 0 116 121" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M19.8056 39.6223L0.500244 0H17.5002L36.1734 36.0124L19.8056 39.6223Z" fill="var(--color-set-one-1)"/>
                    <path class="two" d="M36.8216 44.7789L19.8086 39.6339L41.3565 29.0508L58.4829 34.1875L36.8216 44.7789Z" fill="var(--color-set-one-2)"/>
                    <path  class="two" d="M75.3704 66.1668L58.0938 61.0318L80.9934 52.772L98.1198 57.9087L75.3704 66.1668Z" fill="var(--color-set-one-2)"/>
                    <path d="M41.3564 29.0508L58.0936 61.0319L71.4346 56.223L60.3526 34.7522L41.3564 29.0508Z" fill="var(--color-set-one-1)"/>
                    <path d="M80.9629 52.792L116 121V91.5L99.9591 58.4917" fill="var(--color-set-one-1)"/>
                </svg>
            </div>
            <?php } ?>
        <?php endif; ?>
        <div class="after"></div>
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                <div class="icon">
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
		        <?php else: ?>
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                <?php endif; ?>		
                </div>
            <?php endif; ?>
            <?php if(!empty($settings['titles'])): ?>
                <div class="title_22">
                    <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                        <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php if($settings['content_enable'] == 'yes'): 
                if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
            <?php endif; endif; ?>
            
            <?php if($settings['link_enable'] == 'yes'): if(!empty($settings['button_text'])): ?>
                <a class="rd_more" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <?php echo esc_html($settings['button_text']);?><i class="icontb fi-rs-arrow-small-right"></i>
                </a> 
            <?php endif; endif; ?>
    </div>
    </div>
    <?php // style ?>
    <?php elseif($settings['icon_box_style'] == 'style_two'):  ?>
    <?php // style ?>

    <div class="icon_box_only trans type_one type_two">
        <div class="icon_box_in trans"> 
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                <div class="icon">
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
		        <?php else: ?>
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                <?php endif; ?>	
                </div>
            <?php endif; ?>
            <?php if(!empty($settings['titles'])): ?>
                <div class="title_18">
                    <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                        <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php if($settings['content_enable'] == 'yes'): 
                if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
            <?php endif; endif; ?>
            
            <?php if($settings['link_enable'] == 'yes'): if(!empty($settings['button_text'])): ?>
                <a class="rd_more" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <?php echo esc_html($settings['button_text']);?><i class="icontb fi-rs-arrow-small-right"></i>
                </a> 
            <?php endif; endif; ?>
    </div>
    </div>

    <?php // style ?>
    <?php elseif($settings['icon_box_style'] == 'style_three'):  ?>
    <?php // style ?>
    <div class="icon_box_only type_three trans">
        <div class="icon_inner trans">
        <div class="d-flex trans"> 
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                <div class="icon">
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
		        <?php else: ?>
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                <?php endif; ?>	
                </div>
            <?php endif; ?>
            <div class="content">
            <?php if(!empty($settings['titles'])): ?>
                <div class="title_22">
                    <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                        <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php if($settings['content_enable'] == 'yes'): 
                if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
            <?php endif; endif; ?>
            
            <?php if($settings['link_enable'] == 'yes'): if(!empty($settings['button_text'])): ?>
                <a class="rd_more" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <?php echo esc_html($settings['button_text']);?><i class="icontb fi-rs-arrow-small-right"></i>
                </a> 
            <?php endif; endif; ?>
            </div>
    </div>
        </div>
    </div>
    <?php // style ?>
    <?php elseif($settings['icon_box_style'] == 'style_four'):  ?>
    <?php // style ?>
    <div class="icon_box_only type_four <?php if($settings['display_inline'] == 'yes'): ?>inline_box<?php endif; ?> trans">
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                <div class="icon">
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
		        <?php else: ?>
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                <?php endif; ?>	
                </div>
            <?php endif; ?>
            <div class="content">
                <?php if(!empty($settings['titles'])): ?>
                    <div class="title_18">
                        <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                        </a>
                    </div>
                <?php endif; ?>	
            </div>
            <?php if($settings['link_enable'] == 'yes'): ?>
                <a class="link" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                <svg width="30" height="32" viewBox="0 0 30 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="15" cy="17" r="15" fill="var(--color-set-one-1)"/>
                    <g clip-path="url(#clip0_117_2846)">
                    <path d="M15.0757 24.3888C15.8841 25.207 17.6847 24.9358 17.8785 23.6492C19.0847 15.6614 25.1202 8.92269 29.6876 2.57279C30.954 0.813155 28.042 -0.858436 26.7921 0.88025C22.6184 6.68227 17.3578 12.7875 15.2998 19.828C12.948 17.4244 10.5867 15.0437 7.94892 12.9317C6.27842 11.5936 3.88886 13.951 5.57736 15.3031C9.01404 18.0559 11.984 21.2659 15.0757 24.3888Z" fill="var(--color-set-one-2)"/>
                    </g>
                    <defs>
                    <clipPath id="clip0_117_2846">
                    <rect width="25" height="25" fill="white" transform="translate(5)"/>
                    </clipPath>
                    </defs>
                </svg>

                </a> 
            <?php endif;  ?>
    </div>
    <?php // style ?>
    <?php elseif($settings['icon_box_style'] == 'style_five'):  ?>
    <?php // style ?>
    <div class="icon_box_only type_five d-flex  trans">
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                <div class="icon">
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
		        <?php else: ?>
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                <?php endif; ?>	
                </div>
            <?php endif; ?>
            <div class="content">
                <?php if(!empty($settings['titles'])): ?>
                    <div class="title_22">
                        <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                        </a>
                    </div>
                <?php endif; ?>	
                <?php if($settings['content_enable'] == 'yes'): 
                if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
                <?php endif; endif; ?>
                <?php if($settings['link_enable'] == 'yes'): if(!empty($settings['button_text'])): ?>
                <a class="rd_more" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <?php echo esc_html($settings['button_text']);?><i class="icontb fi-rs-arrow-small-right"></i>
                </a> 
                <?php endif; endif; ?>
            </div>
          
    </div>
    
    <?php // style ?>
    <?php elseif($settings['icon_box_style'] == 'style_six'):  ?>
    <?php // style ?>
    <div class="icon_box_only type_six trans">
    <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                <div class="icon">
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
		        <?php else: ?>
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                <?php endif; ?>	
                </div>
            <?php endif; ?>
            <div class="content">
                <?php if(!empty($settings['titles'])): ?>
                    <div class="title_22">
                        <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                            <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                        </a>
                    </div>
                <?php endif; ?>	
                <?php if($settings['content_enable'] == 'yes'): 
                if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
                <?php endif; endif; ?>
            </div>
    </div>
    <?php // style ?>
    <?php elseif($settings['icon_box_style'] == 'style_seven'):  ?>
    <?php // style ?>

    <div class="icon_box_only <?php if($settings['box_show_enable'] == 'yes'): ?> boxsha <?php endif; ?> type_seven">
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                <div class="icon">
                <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                    <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
		        <?php else: ?>
                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                <?php endif; ?>		
                </div>
            <?php endif; ?>
            <?php if(!empty($settings['titles'])): ?>
                <div class="title_24">
                    <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>    
                        <?php echo wp_kses($settings['titles'] , $allowed_tags); ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php if($settings['content_enable'] == 'yes'): 
                if(!empty($settings['content'])): ?>
                    <p><?php echo wp_kses($settings['content'] , $allowed_tags); ?></p>
            <?php endif; endif; ?>
            
            <?php if($settings['link_enable'] == 'yes'): if(!empty($settings['button_text'])): ?>
                <a class="rd_more" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <?php echo esc_html($settings['button_text']);?><i class="icontb fi-rs-arrow-small-right"></i>
                </a> 
            <?php endif; endif; ?>
 
    </div>
    <?php // style ?>
    <?php endif; ?>
    <?php // style ?>


    <?php
    }
}

 

