<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Contact_form_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-contact-form-v1';
    }

    public function get_title()
    {
        return __('Contact Form V1' , 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }
 
    protected function register_controls() {
		$this->start_controls_section(
			'contact_form',
			[
				'label' => esc_html__( 'Contact Form', 'vankine-addons' ),
			]
        );
        $this->add_control(
            'contact_form_type',
            [
            'label' => __('Contact Form Type', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'simple' => __( 'Simple Form', 'vankine-addons' ),
                'withtab' => __( 'With Tab', 'vankine-addons' ),
            ],
            'default' => 'withtab' , 
            ]
        );

        $this->add_control(
            'forms_plu',
            [
            'label' => __('Contact Form Plugin type', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'wpforms' => __( 'Wp Forms', 'vankine-addons' ),
                'contactformseven' => __( 'Contact Form 7', 'vankine-addons' ),
            ],
            'default' => 'wpforms' , 
            'condition' => [
                'contact_form_type' => 'simple'
            ],
            ]
        );

        $this->add_responsive_control(
			'tab_alignment',
			[
				'label' => esc_html__( 'Tab Alignment', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'vankine-addons' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'vankine-addons' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'vankine-addons' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .fom_tab_box .nav-tabs ' => 'justify-content: {{VALUE}}!important;',
                ],
                'condition' => [
                    'contact_form_type' => 'withtab'
                ],
			]
		);


        $this->add_control(
            'contact_form_url',
            [
                'label'   => esc_html__( 'Choose Contact Form', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
               'options' =>  vankine_contact_form_7_query('wpforms'),
               'condition' => [
                'contact_form_type' => 'simple' ,
                'forms_plu' => 'wpforms',
                ],
            ]
        );

        
        $this->add_control(
            'contact_form_url_seven',
            [
                'label'   => esc_html__( 'Choose Contact Form', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
               'options' =>  vankine_contact_form_7_query('wpcf7_contact_form'),
               'condition' => [
                'contact_form_type' => 'simple',
                'forms_plu' => 'contactformseven',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'rforms_plu',
            [
            'label' => __('Contact Form Plugin type', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'rwpforms' => __( 'Wp Forms', 'vankine-addons' ),
                'rcontactformseven' => __( 'Contact Form 7', 'vankine-addons' ),
            ],
            'default' => 'rwpforms' , 
            ]
        );


        $repeater->add_control(
            'tab_title',
            [
                'label'       => esc_html__( 'Tab Title', 'vankine-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Planting' , 'vankine-addons'),
            ]
        );
        $repeater->add_control(
            'tab_id',
            [
                'label'       => esc_html__( 'Tab ID', 'vankine-addons' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'tab_default' , 'vankine-addons'),
                'description' =>  esc_html__( 'Please Enter the tab id like this example : (tab_milk , tab_coffee , tab_one)' , 'vankine-addons'),
            ]
        );
        $repeater->add_control(
            'contact_form_url_tab',
            [
                'label'   => esc_html__( 'Choose Contact Form', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
               'options' =>  vankine_contact_form_7_query('wpforms'),
               'condition' => [
                'rforms_plu' => 'rwpforms',
                ],
            ]
        );
        $repeater->add_control(
            'contact_form_url_tab_csev',
            [
                'label'   => esc_html__( 'Choose Contact Form', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
               'options' =>  vankine_contact_form_7_query('wpcf7_contact_form'),
               'condition' => [
                'rforms_plu' => 'rcontactformseven',
                ],
            ]
        );
        $repeater->add_control(
            'image_enable',
           [
              'label' => __('Image Enable', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => __('Yes', 'vankine-addons'),
               'label_off' => __('No', 'vankine-addons'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
         );

        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'image_enable' => 'yes'
                ],
            ] 
        );
        $this->add_control(
            'form_repeater',
            [
                'label' => __( 'Form Repeater', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => __( 'Business', 'vankine-addons' ),
                        'tab_id' => __( 'tab1', 'vankine-addons' ),
                    ],
                    [
                        'tab_title' => __( 'Medical', 'vankine-addons' ),
                        'tab_id' => __( 'tab2', 'vankine-addons' ),
                    ],
                    [
                        'tab_title' => __( 'House', 'vankine-addons' ),
                        'tab_id' => __( 'tab3', 'vankine-addons' ),
                    ],
                    [
                        'tab_title' => __( 'Car', 'vankine-addons' ),
                        'tab_id' => __( 'tab4', 'vankine-addons' ),
                    ],
                ],
                'title_field' => '{{{tab_title}}}',
                'condition' => [
                    'contact_form_type' => 'withtab'
                ],
            ]
        );
 
     $this->end_controls_section(); 

     $this->start_controls_section('title_css',
     [ 
         'label' => __('Title Css', 'vankine-addons'),
         'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
     ]
     );

   

     $this->add_responsive_control(
        'tab_item_padding',
        [
            'label' => esc_html__( 'Tab Item Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .custom_tabs  .nav-tabs li .nav-link ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'tab_item_borderradiuse',
        [
            'label' => esc_html__( 'Tab Item Border Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .custom_tabs  .nav-tabs li .nav-link ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );


 
     $this->add_control(
        'tab_text_color',
         [
            'label' => __('Tab Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .custom_tabs .nav-tabs li .nav-link' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'tab_text_bg_color',
         [
            'label' => __('Tab Text Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .custom_tabs .nav-tabs li .nav-link' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'tab_text_ho_color',
         [
            'label' => __('Hover Tab Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .custom_tabs  .nav-tabs li .nav-link.active ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}} .custom_tabs  .nav-tabs li .nav-link:hover ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'tab_text_ho_bg_color',
         [
            'label' => __('Hover Tab Text Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .custom_tabs  .nav-tabs li .nav-link.active  ' => 'background: {{VALUE}}!important;',
                '{{WRAPPER}} .custom_tabs  .nav-tabs li .nav-link:hover ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'colo',
            [
            'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
    );
     $this->add_control(
         'label_color',
          [
             'label' => __('Label Color', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::COLOR,
             'selectors' => [
                 '{{WRAPPER}} .contact_form_shortcode label , {{WRAPPER}} .wpforms-field-number-slider-hint ' => 'color: {{VALUE}}!important;',
             ],
          ]
     );
     $this->add_responsive_control(
         'label_padding',
         [
             'label' => esc_html__( 'Label Padding', 'vankine-addons' ),
             'type' => \Elementor\Controls_Manager::DIMENSIONS,
             'size_units' => [ 'px', '%', 'em' ],
             'selectors' => [
                 '{{WRAPPER}} .contact_form_shortcode label , {{WRAPPER}} .wpforms-field-number-slider-hint  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
             ],
         ]
     );


     $this->add_control(
        'range_slider_bg',
         [
            'label' => __('Range Slider Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .rangeslider ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    
    $this->add_control(
        'range_ac_slider_bg',
         [
            'label' => __('Range Slider Active Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .rangeslider__fill ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'range_han_slider_bg',
         [
            'label' => __('Range Slider Handle  Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .rangeslider__handle ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    

     $this->add_control(
        'input_check_color',
         [
            'label' => __('Input Check / Radio Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=checkbox]:after, .contact_form_shortcode  input[type=radio]:after ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'input_check_ac_color',
         [
            'label' => __('Input Check / Radio Active Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=checkbox]:checked:after, {{WRAPPER}} .contact_form_shortcode input[type=radio]:checked:after ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );

     $this->add_control(
        'input_color',
         [
            'label' => __('Input / Textarea Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'input_place_holder_color',
         [
            'label' => __('Input / Textarea Placeholder Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input::placeholder , {{WRAPPER}} .contact_form_shortcode textarea::placeholder  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'input_bg_color',
         [
            'label' => __('Input / Textarea Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'input_border_width',
        [
            'label' => esc_html__( 'Input Border Width', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'input_border_color',
         [
            'label' => __('Input / Textarea Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'input_border_radius',
        [
            'label' => esc_html__( 'Input Border Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'input_padding',
        [
            'label' => esc_html__( 'Input / Textarea Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'input_margin',
        [
            'label' => esc_html__( 'Input / Textarea Margin', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode input , {{WRAPPER}} .contact_form_shortcode textarea ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );


    $this->add_control(
        'select_color',
         [
            'label' => __('Select  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single .select2-selection__rendered , {{WRAPPER}} .contact_form_shortcode  .wpforms-field .select2-selection--single .select2-selection__rendered 
                , {{WRAPPER}} .wpforms-field-select select  , {{WRAPPER}} div.wpforms-container .wpforms-form .choices__list--single .choices__item ' => 'color: {{VALUE}}!important;',
                '{{WRAPPER}}  .wpforms-form .choices::after , {{WRAPPER}} .contact_form_shortcode .select2-selection__arrow::before , {{WRAPPER}}  select ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
   
    $this->add_control(
        'select_bg_color',
         [
            'label' => __('Select Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select 
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'select_border_width',
        [
            'label' => esc_html__( 'Select Border Width', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'select_border_color',
         [
            'label' => __('Select Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'select_border_radius',
        [
            'label' => esc_html__( 'Select Border Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'select_padding',
        [
            'label' => esc_html__( 'Select Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'select_margin',
        [
            'label' => esc_html__( 'Select Margin', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  .select2-selection--single , {{WRAPPER}} .contact_form_shortcode .wpforms-field .select2-selection--single , {{WRAPPER}} .wpforms-field-select select
                , {{WRAPPER}}  div.wpforms-container .wpforms-form .choices__inner , {{WRAPPER}}  select ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );

    $this->add_responsive_control(
        'button_position',
        [
        'label' => __('Button Position', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'absolute' => __( 'Absolute', 'vankine-addons' ),
            'relative' => __( 'Relative', 'vankine-addons' ),
        ],
        'default' => 'relative' ,
        'selectors' => [
             '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'position: {{VALUE}}!important;',
        ],
        ]
    );
    $this->add_responsive_control(
        'button_pos',
        [
        'label' => __('Button Position', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'button_bottom_right' => __( 'Bottom Right', 'vankine-addons' ),
            'button_bottom_left' => __( 'Bottom Left', 'vankine-addons' ),
        ],
        'default' => 'button_bottom_right' , 
       
        ]
    );
    $this->add_responsive_control(
        'button_bottom',
        [
            'label' => __('Button Bottom', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'bottom: {{VALUE}}px!important;',
           ],
           'condition' => [
            'button_pos' => ['button_bottom_right' , 'button_bottom_left'],
            ],
        ]
    );
    $this->add_responsive_control(
        'button_right',
        [
            'label' => __('Button Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'right: {{VALUE}}px!important;',
           ],
           'condition' => [
            'button_pos' => 'button_bottom_right'
            ],
        ]
    );
    $this->add_responsive_control(
        'button_left',
        [
            'label' => __('Button Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default' => '',
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                   {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'left: {{VALUE}}px!important;',
           ],
           'condition' => [
            'button_pos' => 'button_bottom_left'
            ],
        ]
    );
    $this->add_responsive_control(
        'button_padding',
        [
            'label' => esc_html__( 'Button Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important; min-height:auto!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'button_borderradiuse',
        [
            'label' => esc_html__( 'Button Border Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );

    $this->add_control(
        'button_color',
         [
            'label' => __('Button Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'button_border_color',
         [
            'label' => __('Button Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'button_bg_color',
         [
            'label' => __('Button Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode   input[type=submit] , {{WRAPPER}} .contact_form_shortcode   button[type=submit], 
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form button[type=submit],
                {{WRAPPER}} .contact_form_shortcode   div.wpforms-container-full .wpforms-form .wpforms-page-button  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'button_hover_color',
         [
            'label' => __('Button Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=submit]:hover , {{WRAPPER}} .contact_form_shortcode   button[type=submit]:hover, 
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form button[type=submit]:hover,
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form .wpforms-page-button:hover ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'button_hover_bor_color',
         [
            'label' => __('Button Hover Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=submit]:hover , {{WRAPPER}} .contact_form_shortcode   button[type=submit]:hover, 
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form button[type=submit]:hover,
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form .wpforms-page-button:hover ' => 'border-color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'button_hover_bg_color',
         [
            'label' => __('Button Hover Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_form_shortcode  input[type=submit]:hover , {{WRAPPER}} .contact_form_shortcode   button[type=submit]:hover, 
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form button[type=submit]:hover,
                {{WRAPPER}} .contact_form_shortcode  div.wpforms-container-full .wpforms-form .wpforms-page-button:hover ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    

     $this->end_controls_section();

}
protected function render() {
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
$form_repeaters = $settings['form_repeater'];
?>

<?php if($settings['contact_form_type'] == 'withtab'): ?>
    <section class="fom_tab_box custom_tabs">
            <ul class="nav nav-tabs links trans"  role="tablist">
                <?php if(!empty($form_repeaters)): ?>
                    <?php foreach($form_repeaters as $key => $form_repeater): ?>
                        <li class="nav-item">
                        <button class="nav-link <?php if($key == 0) echo 'active';?>" id="<?php echo esc_attr($form_repeater['tab_id']);?>-cartab" data-bs-toggle="tab" data-bs-target="#<?php echo esc_attr($form_repeater['tab_id']);?>" type="button" role="tab" aria-controls="<?php echo esc_attr($form_repeater['tab_id']);?>" aria-selected="false">
                         
                                <?php echo esc_attr($form_repeater['tab_title']);?>
                            </button>
                        </li>
                    <?php endforeach; ?>
                <?php endif; ?>
            </ul>
  
                <div class="s_tabs_content tab-content">
                <?php if(!empty($form_repeaters)): ?>
                    <?php foreach($form_repeaters as $key => $form_repeater): ?>
              
                    <div class="tab-pane  <?php if($key == 0) echo 'active';?>" id="<?php echo esc_attr($form_repeater['tab_id']);?>" role="tabpanel" aria-labelledby="<?php echo esc_attr($form_repeater['tab_id']);?>-cartab">
                        <div class="contentbox <?php if($form_repeater['image_enable'] == 'yes'): ?> yes_image d-flex <?php endif; ?>">
                            <div class="contact_form_shortcode">
                                <?php if($form_repeater['rforms_plu'] == 'rwpforms'): ?>
                                    <?php if(!empty($form_repeater['contact_form_url_tab'])): ?>
                                        <?php echo do_shortcode('[wpforms id="' . $form_repeater['contact_form_url_tab'] . '"]'); ?>
                                    <?php else: ?>
                                        <p><?php echo esc_html('There is no contact form please create it' , 'vankine-addons'); ?></p>
                                    <?php endif; ?>
                                <?php elseif($form_repeater['rforms_plu'] == 'rcontactformseven'): ?>
                                    <?php if(!empty($form_repeater['contact_form_url_tab_csev'])): ?>
                                        <?php echo do_shortcode('[contact-form-7 id="' . $form_repeater['contact_form_url_tab_csev'] . '"]'); ?>
                                    <?php else: ?>
                                        <p><?php echo esc_html('There is no contact form please create it' , 'vankine-addons'); ?></p>
                                    <?php endif; ?>
                                <?php endif; ?>    
                                
                            </div> 
                            <?php if($form_repeater['image_enable'] == 'yes'): ?>
                                <?php if(!empty($form_repeater['image']['url'])): ?>
                                    <div class="image trans">
                                        <img src="<?php echo esc_url($form_repeater['image']['url']); ?>" alt="img" />
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div> 
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
                </div>
          
    </section>
    <?php else: ?>
        <section class="contact_form_box_all">
        <div class="contact_form_shortcode">
            <?php if($settings['forms_plu'] == 'wpforms'): ?>
                <?php if(!empty($settings['contact_form_url'])): ?>
                    <?php echo do_shortcode('[wpforms id="' . $settings['contact_form_url'] . '"]'); ?>
                <?php else: ?>
                    <p><?php echo esc_html('There is no contact form please create it' , 'vankine-addons'); ?></p>
                <?php endif; ?>
            <?php elseif($settings['forms_plu'] == 'contactformseven'): ?>
                <?php if(!empty($settings['contact_form_url_seven'])): ?>
                    <?php echo do_shortcode('[contact-form-7 id="' . $settings['contact_form_url_seven'] . '"]'); ?>
                <?php else: ?>
                    <p><?php echo esc_html('There is no contact form please create it' , 'vankine-addons'); ?></p>
                <?php endif; ?>
            <?php endif; ?>    
        </div>
    </section>
<?php endif; ?>
           
		<?php 
	}
}

 


