<?php
/*
** ============================== 
**   Vankine Header File
** ==============================
*/

if(is_page_template( 'template-empty.php' ) || is_404()):
    return false;
endif;
global $vankine_theme_mod;
$header_id = '';
if(!empty($vankine_theme_mod['header_custom_style'])):
    $header_id = $vankine_theme_mod['header_custom_style'];
endif;
if(get_post_meta(get_the_ID() , 'custom_header', true) && !is_post_type_archive('product') && !is_tax('product_cat') && !is_home() && !is_tax() && !is_tag()  && !is_category()):
    $header_id = get_post_meta(get_the_ID() , 'header_settings_meta', true);
elseif(is_post_type_archive('product') || is_tax('product_cat') || is_tax()|| is_tag() || is_category() || is_home()):
    if(!empty($vankine_theme_mod['header_archive_style'])):
        $header_id = $vankine_theme_mod['header_archive_style'];
    endif;
endif;

$header_content = vankine_elementor_builder_content_for_display($header_id);

$header_custom_enables = '';
if(!empty($vankine_theme_mod['header_custom_enables'])):
$header_custom_enables = $vankine_theme_mod['header_custom_enables'];
endif;
function  vankine_default_header(){
    $blog_title = get_bloginfo('name');
?>
<header class="default_header">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-xl-3 col-lg-3 col-md-8 col-sm-8 col-xs-8 logo_col">
                <div class="logo_box">
                    <a href="<?php  echo esc_url(home_url()); ?>" class="logo text">
                    <?php echo esc_attr($blog_title); ?>
                        <h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
                    </a>
                </div>
            </div>
            <div class="col-xl-9 col-lg-9 col-md-4 col-sm-4 col-xs-4 men_col">
            <div class="navbar_togglers hamburger_menu">
                                <span class="line"></span>
                                <span class="line"></span>
                                <span class="line"></span>
                            </div>
                <div class="navbar_content">
                    <?php wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'container' => false,
                        'menu_class' => 'navbar_nav',
                        'fallback_cb'    => 'Vankine_WP_Bootstrap_Navwalker::fallback',
                        'walker' => new \Vankine_WP_Bootstrap_Navwalker()
                    ));?>
                </div>
            </div>
        </div>
    </div>
</header>

 
<?php  } ?>
<?php if($header_custom_enables == false): ?>
       <?php vankine_default_header(); ?>
<?php else: ?>
<div class="header_area <?php if(!empty($vankine_theme_mod['dropdownlastthree_row']) == true): ?>dropdownlastthree_row<?php endif; ?>" id="header_contents">
    <?php 
        if ($header_content !== null) {
          echo do_shortcode($header_content);
        } else {
            echo esc_html__('Sorry, no posts matched your criteria.' , 'ecom');
        }
    ?>
</div>
<?php
 endif; ?>
 