<?php
/*
**=======================================
** Vankine Default Blog Content
**=======================================
*/
global $vankine_theme_mod;
 
$featured_img_url = get_the_post_thumbnail_url($post->ID, 'full'); 
$post_video_link_get = '';
$post_video_link = get_post_meta(get_the_ID() , 'post_video_link', true);
if(!empty($post_video_link)):
$post_video_link_get = $post_video_link;
else:
$post_video_link_get = esc_html('https://youtu.be/FHXTWNpZxq4' , 'vankine');
endif;
 
?>
<div <?php post_class('col-xl-12'); ?>>
  <article class="blog_style one <?php if(has_post_thumbnail()): ?>has_images<?php else: ?>no_images<?php endif; ?>" id="post-<?php esc_attr(the_ID()); ?>">
    <?php if(!empty($featured_img_url)): ?>
    <div class="image_box <?php if(!empty($vankine_theme_mod['excerpt_enable']) == true): ?>excerpt_enabled<?php endif; ?>">
      <?php if(get_post_meta(get_the_ID() , 'post_video_enable', true) == true): ?>
      <a href="<?php echo esc_url($post_video_link); ?>" class="lightbox-image blog_video">
        <i class="fa fa-play"></i>
      </a>
      <?php endif; ?>
        <a href="<?php echo esc_url(get_permalink()); ?>">
          <img class="border-radius-15" src="<?php echo esc_url($featured_img_url); ?>" alt="<?php the_title(); ?>" />
        </a>
    </div>
    <?php endif; ?>
    <div class="content_box">
      <div class="d-flex top align-items-center">
        <?php do_action('vankine_theme_blog_category'); ?>
       
       <?php do_action('vankine_theme_blog_time'); ?>
      </div>
      <div class="d-flex authour align-items-center">
           <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'Vankine-authour', 100 )); ?> 
           <?php the_author(); ?>
        </div>
      <?php the_title( '<h2 class="tit_ho title_28"><a href="' .  esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>' ); ?>
      <?php if(!empty($vankine_theme_mod['excerpt_enable']) == true): ?>
      <?php $excerpt = ''; ?>
       <?php if(has_excerpt()): ?>
        <p> 
          <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , 10)); ?>
          <?php echo esc_attr($excerpt); ?>
       </p> 
       <?php endif; ?>
       <?php endif; ?>
          <div class="bottom d-flex  align-items-center">
            <a href="<?php echo esc_url(get_permalink()); ?>"  class="rd_more"><?php echo esc_html('Read More' , 'vankine'); ?><i class="fi-rr-arrow-small-right"></i></a>
            <?php do_action('vankine_theme_blog_comments'); ?>
          </div>
      </div>
  </article>
</div>