<?php
/*
**==============================   
** Vankine 404 File
**==============================
*/
get_header();
global $vankine_theme_mod;
$error_image = '';
if(!empty($vankine_theme_mod['404_image']['url'])):
    $error_image = $vankine_theme_mod['404_image']['url'];
else:
    $error_image = get_template_directory_uri().'/assets/images/page-404.png'; 
endif;
?>
<main class="main page-404">
    <div class="page-content">
        <div class="m-auto text-center">
            <p class="m-auto">
                <img class="m-auto" src="<?php echo esc_url($error_image); ?>" alt="" class="hover-up">
            </p>
            <h1 class="title_no_a_36">
                <?php echo esc_html_e('Page Not Found', 'vankine'); ?>
            </h1>
            <p>
                <?php echo esc_html_e( 'The page you are looking for was moved, removed, renamed or never existed.', 'vankine' ); ?>
            </p>
            <div class="search-form text-center">
                <?php do_action('vankine_custom_search_setup'); ?>
            </div>
            <div class="text-cetner">
                <a class="theme_btn" href="<?php echo esc_url(home_url()); ?>"><i class="fi-rs-home mr-5"></i>
                    <?php esc_html_e('Back to home', 'vankine'); ?></a>
            </div>
        </div>
    </div>
</main>
<?php get_footer();?> 