<?php

namespace  Vankineaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Menu_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-menu-v1';
    }

    public function get_title()
    {
        return __('Menu V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('menu_settings',
        [ 
            'label' => __('Menu Settings', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );

         
    $this->add_control(
        'navigations',
        [
            'label' => __('Select Navigation', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => vankine_navmenu(),
        ]
    );
        

    
    $this->add_control(
        'icon_position',
        [
          'label' => __('Menu Icon Position', 'vankine-addons'),
          'type' => \Elementor\Controls_Manager::SELECT,
          'options' => [
            'iconpo_one' => __( 'Position One', 'vankine-addons' ),
            'iconpo_two' => __( 'Position Two', 'vankine-addons' ),
        ],
          'default' => 'iconpo_one' , 
        ]
     );

    $this->add_responsive_control(
        'text_align',
        [
            'label' => esc_html__( 'Alignment', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'start' => [
                    'title' => esc_html__( 'Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'end' => [
                    'title' => esc_html__( 'Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'default' => 'center',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .navbar_content  ' => 'justify-content: {{VALUE}}!important;',
            ],
        ]
    );
    $this->end_controls_section();
 
    $this->start_controls_section('menu_css',
    [ 
        'label' => __('Menu Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]);
    $this->add_control(
        'navbar_contentbg',
        [
            'label' => __('Menu Background', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .menu_boxed  .navbar_content .navbar_nav ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_control(
        'navbar_contentpd',
        [
            'label' => esc_html__( 'Menu Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
  
            'selectors' => [
                '{{WRAPPER}}  .menu_boxed  .navbar_content .navbar_nav ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );

    $this->add_control(
        'navbar_contentbor',
        [
            'label' => esc_html__( 'Menu Border Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
  
            'selectors' => [
                '{{WRAPPER}}  .menu_boxed  .navbar_content .navbar_nav ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'css_h1_4',
        [
            'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
    );
    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( 'Menu Typography', 'vankine-addons' ),
            'name' => 'menu_typo',
            'selector' => '{{WRAPPER}} .main-menu > nav > ul > li > a ',
        ]
    ); 
    $this->add_responsive_control(
        'menu_item_padding',
        [
            'label' => esc_html__( 'Menu Item Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
	$this->add_responsive_control(
        'menu_item_margin',
        [
            'label' => esc_html__( 'Menu Item Margin', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'menu_item_color',
        [
            'label' => __('Menu Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > a.nav_link  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
	$this->add_responsive_control(
        'menu_item_bg_color',
        [
            'label' => __('Menu Item Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item    ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'menu_item_active_colosr',
        [
            'label' => __('Menu Active / Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .current_page_item > a.nav_link , {{WRAPPER}} .navbar_nav > .menu-item > a.nav_link:hover  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'hover_menuarr_color',
        [
            'label' => __('Menu Hover Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .current_page_item .fa-angle-down  , {{WRAPPER}} .navbar_nav > .menu-item:hover .fa-angle-down  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
	$this->add_responsive_control(
        'menu_itemac_bg_colorss',
        [
            'label' => __('Menu Item Active / Hover Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item.current_page_item , {{WRAPPER}} .navbar_nav > .menu-item:hover  ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'menu_item_arrow_color',
        [
            'label' => __('Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > li > .dropdown-btn .fa-angle-down  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'arrow_move_right',
        [
            'label' => __('Arrow Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 1,
            'min'     => -150,
            'max'     => 150,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > li > .dropdown-btn .fa-angle-down ' => 'right: {{VALUE}}px!important; position:relative;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'multiple_dropborder_color',
        [
            'label' => esc_html__( 'Dropdown Tile Border Color', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}  .menu_boxed .navbar_nav .mennucolumn_two > ul > li > a , {{WRAPPER}}   .menu_boxed .navbar_nav .mennucolumn_three > ul > li > a,  {{WRAPPER}}  .menu_boxed .navbar_nav .mennucolumn_four > ul > li > a, {{WRAPPER}}  .menu_boxed .navbar_nav .mennucolumn_five > ul > li > a, {{WRAPPER}}  .default_header .navbar_nav .mennucolumn_two > ul > li > a, {{WRAPPER}}  .default_header .navbar_nav .mennucolumn_three > ul > li > a, {{WRAPPER}}  .default_header .navbar_nav .mennucolumn_four > ul > li > a, {{WRAPPER}}  .default_header .navbar_nav .mennucolumn_five > ul > li > a, body .menu_content_in .navbar_nav .mennucolumn_two > ul > li > a, {{WRAPPER}}  .menu_content_in .navbar_nav .mennucolumn_three > ul > li > a, {{WRAPPER}}  .menu_content_in .navbar_nav .mennucolumn_four > ul > li > a, {{WRAPPER}}  .menu_content_in .navbar_nav .mennucolumn_five > ul > li > a' => 'border-color: {{VALUE}}!important;',
            ], 
        ]
    );
    $this->add_responsive_control(
        'drop_down_menuarr_color',
        [
            'label' => __('Drop Down Menu Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav   .menu-item  .sub_menu .dropdown-btn .fa-angle-down  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
   
    $this->add_responsive_control(
        'drop_down_menu_color',
        [
            'label' => __('Drop Down Menu Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'dmenu_item_border',
        [
            'label' => esc_html__( 'Dropdown Menu Item Border Width', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_control(
        'dmenu_item_border_types',
        [
          'label' => __('Dropdown Menu Item Border Type', 'vankine-addons'),
          'type' => \Elementor\Controls_Manager::SELECT,
          'options' => [
            'none' => __( 'None', 'vankine-addons' ),
            'solid' => __( 'Solid', 'vankine-addons' ),
            'dashed' => __( 'Dashed', 'vankine-addons' ),
            'dotted' => __( 'Dashed', 'vankine-addons' ),
          ],
          'default' => '' , 
          'selectors' => [
            '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'border-style: {{VALUE}}!important;',
        ],
        ]
     );
    $this->add_responsive_control(
        'dropbr_down_menu_color',
        [
            'label' => __('Drop Down Menu Border  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'border-color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'drop_down_menubg_color',
        [
            'label' => __('Drop Down Menu Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 

    $this->add_responsive_control(
        'hover_drop_down_menu_color',
        [
            'label' => __('Drop Down Menu Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a:hover ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'hoverdrop_down_menuarr_color',
        [
            'label' => __('Drop Down Menu Hover Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li:hover .dropdown-btn .fa-angle-down  ' => 'color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'hover_drop_downbr_menu_color',
        [
            'label' => __('Drop Down Menu Hover Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a:hover ' => 'border-color: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'hover_drop_down_bgmenu_color',
        [
            'label' => __('Drop Down Menu Hover Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a:hover ' => 'background: {{VALUE}}!important;',
            ],
        ]
    );  
    $this->add_responsive_control(
        'dmenu_item_paddings',
        [
            'label' => esc_html__( 'Dropdown Menu Item Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li a ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                '{{WRAPPER}} .navbar_nav ul li a ' => 'margin-bottom:0!important;',
            ],
        ]
    );
   
	$this->add_responsive_control(
        'dmenu_item_margin',
        [
            'label' => esc_html__( 'Dropdown Menu Item Margin', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav > .menu-item > .sub_menu li ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'mutiple_column_gap',
        [
            'label' => __('Mutiple Dropdown Column Gap', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 1,
            'min'     => 0,
            'max'     => 200,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav .sub_menu ' => 'gap: {{VALUE}}px!important;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'drop_down_bg_color',
        [
            'label' => __('Drop Down Background Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .navbar_nav .menu-item .sub_menu ' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'dmenu_box_padding',
        [
            'label' => esc_html__( 'Dropdown  Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .navbar_nav .menu-item .sub_menu ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    ); 
    $this->add_responsive_control(
        'drop_widths',
        [
            'label' => __( 'Dropdown Width For( Mega Menu )', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 1,
            'max' => 2000,
            'step' => 1,
            'selectors' => [
                '{{WRAPPER}} .menu_boxed li.mega_menu .sub_menu , {{WRAPPER}} .dropbimenu.mennucolumn_full-six > .sub_menu , {{WRAPPER}} .dropbimenu.mennucolumn_full-seven > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-eight > .sub_menu 
                , {{WRAPPER}} .dropbimenu.mennucolumn_full-five > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-four > .sub_menu
                , {{WRAPPER}} .dropbimenu.mennucolumn_full-three > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-two > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-one > .sub_menu
                , {{WRAPPER}} .dropbimenu.mennucolumn_full > .sub_menu ' => 'width: {{VALUE}}%;',
            ],
        ]
    ); 

    $this->add_responsive_control(
        'drop_lefts',
        [
            'label' => __( 'Dropdown Move Left For ( Mega Menu )', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => -3000,
            'max' => 3000,
            'step' => 1, 
            'selectors' => [
                '{{WRAPPER}} .menu_boxed li.mega_menu .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-six > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-seven > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-eight > .sub_menu 
                , {{WRAPPER}} .dropbimenu.mennucolumn_full-five > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-four > .sub_menu
                , {{WRAPPER}} .dropbimenu.mennucolumn_full-three > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-two > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-one > .sub_menu
                , {{WRAPPER}} .dropbimenu.mennucolumn_full > .sub_menu ' => 'left: {{VALUE}}%', 
            ],
        ]
    );
    
    $this->add_responsive_control(
        'drop_right',
        [
            'label' => __( 'Dropdown Move Right For ( Mega Menu )', 'vankine-addons' ),
            'description' => __( 'Note This Option Only for rtl Users', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => -3000,
            'max' => 3000,
            'step' => 1, 
            'selectors' => [
                '{{WRAPPER}} .menu_boxed li.mega_menu .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-six > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-seven > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-eight > .sub_menu 
                , {{WRAPPER}} .dropbimenu.mennucolumn_full-five > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-four > .sub_menu
                , {{WRAPPER}} .dropbimenu.mennucolumn_full-three > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-two > .sub_menu  , {{WRAPPER}} .dropbimenu.mennucolumn_full-one > .sub_menu
                , {{WRAPPER}} .dropbimenu.mennucolumn_full > .sub_menu ' => 'right: {{VALUE}}%; left:unset!important;', 
            ],
        ]
    );
 
    $this->add_control(
        'navigation_btn_color',
        [
            'label' => __('Navigation Button  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .menu_boxed .m_bx .navbar_togglers  .line' => 'background: {{VALUE}}!important;',
            ],
        ]
    ); 
   
    $this->add_responsive_control(
        'move_top',
        [
            'label' => __( 'Navigation Button Move Top ( For Mobile)', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => 1,
            'max' => 300,
            'step' => 1,
            'selectors' => [
                '{{WRAPPER}} .menu_boxed .m_bx  ' => 'top: {{VALUE}}%',
            ],
        ]
    );

    $this->add_responsive_control(
        'mover_left',
        [
            'label' => __( 'Navigation Button Move Right ( For Mobile)', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => -3000,
            'max' => 3000,
            'step' => 1,
            'selectors' => [
                '{{WRAPPER}} .menu_boxed .m_bx  ' => 'right: {{VALUE}}%',
            ],
        ]
    );

    

    $this->add_responsive_control(
        'navvigtion_button_alignment',
        [
            'label' => esc_html__( 'Menu Button Alignment ( For Mobile)', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'start' => [
                    'title' => esc_html__( 'Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'end' => [
                    'title' => esc_html__( 'Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'default' => 'end',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .menu_boxed .m_bx  ' => 'justify-content: {{VALUE}}!important;',
            ],
        ]
    );


    $this->add_responsive_control(
        'drop_sub',
        [
            'label' => __( 'Dropdown Move Left For ( Sub Menu Having Columns )', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'min' => -3000,
            'max' => 3000,
            'step' => 1, 
            'selectors' => [
                '{{WRAPPER}}  .dropbimenu  .sub_menu ' => 'left: {{VALUE}}%', 
            ],
        ]
    );

    $this->end_controls_section(); 

    } 
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');

?>

<div class="menu_boxed <?php echo esc_attr($settings['icon_position']); ?>">
    <div class="m_bx">
        <div class="navbar_togglers hamburger_menu">
            <span class="line"></span>
            <span class="line"></span>
            <span class="line"></span>
        </div>
    </div>
    <div class="navbar_content d-flex align-items-center">
    <?php if(!empty($settings['navigations'])):
         wp_nav_menu(array(
            'menu' => $settings['navigations'],
            'container' => false,
            'menu_class' => 'navbar_nav',
            'fallback_cb'    => 'Vankine_WP_Bootstrap_Navwalker::fallback',
            'walker' => new \Vankine_WP_Bootstrap_Navwalker()
        )); 
    endif; ?>                   
    </div>
</div>
 
<?php
    }
}