<?php

namespace  Vankineaddons\Core\Widgets\Footer;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Foo_gallery_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-foogal-v1';
    }

    public function get_title()
    {
        return __('Footer Gallery Box V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['104'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('footer_gallery',
        [ 
            'label' => __('Galley Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
      
        $repeater = new \Elementor\Repeater();
   
        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ] 
        );
          
        $repeater->add_responsive_control(
            'link',
            [
                'label' => __('Link', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'vankine-addons'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );
        $this->add_control(
            'image_repeaters',
            [
                'label' => __('Faqs Box Content', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                     'image' =>  __('', 'vankine-addons'),
                     'link' =>  __('#', 'vankine-addons'),
                     ],
                ],
                'title_field' =>  __('Image', 'vankine-addons'),
    
            ]
        );
    
    $this->end_controls_section();

    $this->start_controls_section('custom_css',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
  
    $this->add_control(
        'overlay_color',
         [
            'label' => __('Overlay Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .g_box a:before ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
      
     
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
 
     ?>
    <div class="g_box d-flex">
    <?php foreach($settings['image_repeaters'] as  $key => $image_repeater):
        $target = $image_repeater['link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $image_repeater['link']['nofollow'] ? ' rel="nofollow"' : '';
    ?>
    <?php if(!empty($image_repeater['image']['url'])): ?>
        <a class="trans"  href="<?php echo esc_url($image_repeater['link']['url']); ?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
           
                <img src="<?php echo esc_url($image_repeater['image']['url']); ?>" alt="img" />
                <svg class="trans" width="55" height="55" viewBox="0 0 55 55" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <circle cx="28" cy="27" r="20" fill="white"/>
                    <circle cx="27.5" cy="27.5" r="27.5" fill="white" fill-opacity="0.1"/>
                    <path d="M22 33.25L33.25 22M33.25 22H24.8125M33.25 22V30.4375" stroke="#2D947A" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
         
        </a>
    <?php endif; ?>   
    <?php endforeach;?>
    </div>
    <?php
    }
}

 

