<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Title_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-title-v1';
    }

    public function get_title()
    {
        return __('Title V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('title_v1_settings',
        [ 
            'label' => __('Title Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'title_style',
            [
            'label' => __('Title Styles', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'vankine-addons' ),
            ],
            'default' => 'style_one' , 
            ]
        );

        $this->add_control(
            'title_tag',
            [
            'label' => __('Title Tag', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'div' => __( 'Div Tag', 'vankine-addons' ),
                'h1' => __( 'H1 Tag', 'vankine-addons' ),
                'h2' => __( 'H2 Tag', 'vankine-addons' ),
                'h3' => __( 'H3 Tag', 'vankine-addons' ),
                'h4' => __( 'H4 Tag', 'vankine-addons' ),
                'h5' => __( 'H5 Tag', 'vankine-addons' ),
                'h6' => __( 'H6 Tag', 'vankine-addons' ),
            ],
            'default' => 'h2' , 
            ]
        );

        $this->add_responsive_control(
            'sm_title',
            [
               'label' => __('Sub Title', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('Our performance', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),    
            ]
        );
         
        $this->add_responsive_control(
          'title',
          [
             'label' => __('Title', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Your Partner for e-commerce grocery solution', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),    
          ]
        );
        $this->add_responsive_control(
            'description',
            [
              'label' => __('Description', 'vankine-addons'),
              'type' => \Elementor\Controls_Manager::TEXTAREA,
              'default' => __('Pitatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia', 'vankine-addons'),
              'placeholder' => __('Type your text here', 'vankine-addons'),
            ]
        );

      
     
        $this->end_controls_section();


        $this->start_controls_section('title_css',
        [ 
            'label' => __('Title Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Sub Title Typography', 'vankine-addons' ),
				'name' => 'sm_typo',
				'selector' => '{{WRAPPER}} .section_title h4',
			]
		);
        $this->add_control(
            'sm_title_color',
             [
                'label' => __('Sub Title Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title h4 ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_responsive_control(
			'sm_margin',
			[
				'label' => esc_html__( 'Sub Title Padding', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_title h4 ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Title Typography', 'vankine-addons' ),
				'name' => 'title_typo',
				'selector' => '{{WRAPPER}} .section_title .title',
			]
		);
        $this->add_control(
            'title_color',
             [
                'label' => __('Title Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title .title , {{WRAPPER}} .section_title .title span:after ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Title Margin', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_title  .title ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				],
			]
		);
        $this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_title  .title ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( ' Description Typography', 'vankine-addons' ),
				'name' => 'desc_typo',
				'selector' => '{{WRAPPER}} .section_title p',
			]
		);
        $this->add_control(
            'description_color',
             [
                'label' => __('Description Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section_title p ' => 'color: {{VALUE}}!important;',
                ],
             ]
        );
        $this->add_responsive_control(
			'description_margin',
			[
				'label' => esc_html__( 'Description Padding', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .section_title p ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				],
			]
		);
       
        $this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'vankine-addons' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'vankine-addons' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'vankine-addons' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .section_title ' => 'text-align: {{VALUE}}!important;',
                ],
			]
		);

        $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
     
     
    ?>
    <?php // style ?>
    <?php if($settings['title_style'] == 'style_one'):  ?>
    <?php // style ?>
        <div class="section_title type_one">
            <?php if(!empty($settings['sm_title'])): ?>
                <h4 class="sm_title"> <?php echo wp_kses($settings['sm_title'] , $allowed_tags);  ?></h4>
            <?php endif; ?>
            <?php if(!empty($settings['title'])): ?>
                <div class="title_whole">
                    <?php if($settings['title_tag'] == 'div'): ?>
                        <div class="title"> <?php echo wp_kses($settings['title'] , $allowed_tags);  ?>  </div>
                    <?php elseif($settings['title_tag'] == 'h1'): ?>
                        <h1 class="title"> <?php echo wp_kses($settings['title'] , $allowed_tags);  ?>  </h1>
                    <?php elseif($settings['title_tag'] == 'h2'):?>
                        <h2 class="title"> <?php echo wp_kses($settings['title'] , $allowed_tags);  ?>  </h2>
                    <?php elseif($settings['title_tag'] == 'h3'):?>
                        <h3 class="title"> <?php echo wp_kses($settings['title'] , $allowed_tags);  ?>  </h3>
                    <?php elseif($settings['title_tag'] == 'h4'):?>
                        <h4 class="title"> <?php echo wp_kses($settings['title'] , $allowed_tags);  ?>  </h4>
                    <?php elseif($settings['title_tag'] == 'h5'):?>
                        <h5 class="title"> <?php echo wp_kses($settings['title'] , $allowed_tags);  ?>  </h5>
                    <?php elseif($settings['title_tag'] == 'h6'):?>
                        <h6 class="title"> <?php echo wp_kses($settings['title'] , $allowed_tags);  ?>  </h6>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if(!empty($settings['description'])): ?>
                <p> <?php echo wp_kses($settings['description'] , $allowed_tags);  ?></p>
            <?php endif; ?>
        </div>
    <?php // style ?>
    <?php endif; ?>
    <?php // style ?>


    <?php
    }
}

 

