<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Testi_carousel_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-testimonil-carousel-v1';
    }

    public function get_title()
    {
        return __('Testimonial  Carousel  V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
    // style one start
    $this->start_controls_section('testc_settings',
    [ 
        'label' => __('Testimonial Content', 'vankine-addons'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
    );
    $this->add_control(
        'testi_style',
        [
        'label' => __('Testimonial Styles', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'style_one' => __( 'Style One', 'vankine-addons' ),
            'style_two' => __( 'Style Two', 'vankine-addons' ),
            'style_three' => __( 'Style Three', 'vankine-addons' ),
        ],
        'default' => __('style_one' , 'vankine-addons'),
        ]
    );
    $this->add_control(
        'desktop',
        [
            'label' => __('Carousel Items to Display Desktop', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => 0,
            'max'     => 10,
            'step'    => 1,
            'default' => '3',
        ]
    );
    $this->add_control(
        'tablet',
        [
            'label' => __('Carousel Items to Display Tablet', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => 0,
            'max'     => 10,
            'step'    => 1,
            'default' => '3',
        ]
    );
    $this->add_control(
        'mobile',
        [
            'label' => __('Carousel Items to Display Mobile', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => 0,
            'max'     => 10,
            'step'    => 1,
            'default' => '1',
        ]
    );
    $this->add_control(
        'item_margin',
        [
            'label' => __('Carousel Items Space', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => 0,
            'max'     => 100,
            'step'    => 1,
            'default' => 20,
        ]
    );

    
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'image_enable',
        [
            'label' => __('Image Enable', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'vankine-addons'),
            'label_off' => __('No', 'vankine-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => __('Image', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'image_enable' => 'yes',
                ],
            ]
        );
        $repeater->add_control(
            'name',
            [
            'label'       => esc_html__( 'Name', 'vankine-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default' =>  esc_html__( 'Jacob Leonardo' , 'vankine-addons'),
        ]);
        $repeater->add_control(
            'designation',
            [
            'label'       => esc_html__( 'Designation', 'vankine-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default' =>  esc_html__( 'Senior Manager of Excel Solution' , 'vankine-addons'),
        ]);
        $repeater->add_control(
            'comments',
            [
            'label'       => esc_html__( 'Comment', 'vankine-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXTAREA,
            'default' =>  esc_html__( 'While running an early stage startup everything feels
            hard, that’s why it’s been so nice to have our accounting
            feel easy. We recommed Qetus.' , 'vankine-addons'),
        ]);
        $repeater->add_control(
            'rating_enable',
        [
            'label' => __('Rating Enable', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'vankine-addons'),
            'label_off' => __('No', 'vankine-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]
        );
        $repeater->add_control(
            'content',
            [
            'label'       => esc_html__( 'Content', 'vankine-addons' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default' =>  esc_html__( 'Jacob Leonardo' , 'vankine-addons'),
            'description' =>  esc_html__( 'Content For Style two' , 'vankine-addons'),
        ]);
        $repeater->add_control(
            'rating_one',
            [
                'label' => __( 'Rating', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' =>  'two' , 
                'options' => [
                    'one' => __('1', 'vankine-addons'),
                    'two' => __('2', 'vankine-addons'),
                    'three' => __('3', 'vankine-addons'),
                    'four' => __('4', 'vankine-addons'),
                    'five' => __('5', 'vankine-addons'),
                ],
                'condition' => [
                    'rating_enable' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'testi_repeater',
            [
                'label' => __('Testimonial Content', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image_enable' => 'yes' ,
                        'name' =>  __('Fleix Everard ', 'vankine-addons'),
                        'designation' =>  __('HR, Blue Soft Sol', 'vankine-addons'),
                        'comments'  =>  __('Sed perspiciatis unonis 
                        este natus error sit volutate accusantium dolor laudant totam rem aperiam eaupsa abillo inven veritatis', 'vankine-addons'),
                        'rating_enable' => 'yes' ,
                        'rating_one' => 'three' ,
                    ],
                    [
                        'image_enable' => 'yes' ,
                        'name' =>  __('Boris Elbert ', 'vankine-addons'),
                        'designation' =>  __('Green Tech', 'vankine-addons'),
                        'comments'  =>  __('Sed perspiciatis unonis 
                        este natus error sit volutate accusantium dolor laudant totam rem aperiam eaupsa abillo inven veritatis', 'vankine-addons'),
                        'rating_enable' => 'yes' ,
                        'rating_one' => 'three'
                    ], 
                    [
                        'image_enable' => 'yes' ,
                        'name' =>  __('Ivor Herbert', 'vankine-addons'),
                        'designation' =>  __('Manager, Airlines', 'vankine-addons'),
                        'comments'  =>  __('Sed perspiciatis unonis 
                        este natus error sit volutate accusantium dolor laudant totam rem aperiam eaupsa abillo inven veritatis', 'vankine-addons'),
                        'rating_enable' => 'yes' ,
                        'rating_one' => 'three'
                    ]
                ],
                'title_field' => '{{{ name }}}',

            ]
        );
     
    $this->end_controls_section();


    
    $this->start_controls_section('csutomcss',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
   
   
    $this->add_control(
        'bg_color',
         [
            'label' => __('Box Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one , {{WRAPPER}} .testimonial_box.type_two ' => 'background: {{VALUE}}!important;', 
            ],
         ]
    );

    $this->add_control(
        'bg_border_color',
         [
            'label' => __('Box Hover Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_two ' => 'border-color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_two',
            ],
         ]
    );

    $this->add_control(
        'rating_color',
         [
            'label' => __('Rating Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .top_content p i , {{WRAPPER}} .testimonial_box.type_two .box p i ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );

    
    $this->add_control(
        'rating_bg_color',
         [
            'label' => __('Rating Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_two .box , {{WRAPPER}} .testimonial_box.type_two.type_three .box ' => 'background: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => ['style_two' , 'style_three'],
            ],
         ]
    );

     
    $this->add_control(
        'rating_text_color',
         [
            'label' => __('Rating Text Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_two .box h6  ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => ['style_two' , 'style_three'],
            ],
         ]
    );

    $this->add_control(
        'desc_color',
         [
            'label' => __('Description Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_carousel .testimonial_box.type_one .top_content .title_no_a_30 , {{WRAPPER}} .testimonial_box.type_two .t_comment ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );
  
    $this->add_control(
        'image_bg',
         [
            'label' => __('Image Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .lower_content .image_box svg path ' => 'fill: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_one',
            ],
         ]
    );
 
   
    $this->add_control(
        'auth_color',
         [
            'label' => __('Authour Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .lower_content .cont .title_no_a_22 , {{WRAPPER}} .testimonial_box.type_two .auth .cont .title_no_a_24 ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );
    $this->add_control(
        'desg_color',
         [
            'label' => __('Job Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box .cont p  ' => 'color: {{VALUE}}!important;', 
            ],
         ]
    );

    $this->add_control(
        'quote_bg_color',
         [
            'label' => __('Quote Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .flaticon-right-quote ' => 'background: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_one',
            ],
         ]
    );

    $this->add_control(
        'quote_teobg_color',
         [
            'label' => __('Quote Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one:after ' => 'background: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_one',
            ],
         ]
    );
    
    
    $this->add_control(
        'quote_color',
         [
            'label' => __('Quote  Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .testimonial_box.type_one .flaticon-right-quote ' => 'color: {{VALUE}}!important;', 
            ],
            'condition' => [
                'testi_style' => 'style_one',
            ],
         ]
    );

    $this->end_controls_section();

    $this->start_controls_section('owl_nav_style',
    [ 
        'label' => __('Naigation Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
   
    $this->add_control(
        'nav_display',
        [
        'label' => __('Naigation Enable / Disabel', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'nav_true' => __( 'Block', 'vankine-addons' ),
            'nav_false' => __( 'none', 'vankine-addons' ),
        ],
        'default' => 'nav_true' , 
       
        ]
    );

  
 
    $this->add_control(
        'nav_style_options',
        [
        'label' => __('Nav Move Position', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'position_one' => __( 'Position One', 'vankine-addons' ),
            'position_two' => __( 'Position Two', 'vankine-addons' ),
            'position_three' => __( 'Position Three', 'vankine-addons' ),
            'position_four' => __( 'Position Four', 'vankine-addons' ),
        ],
        'default' => 'position_one' , 
        ]
    );
    $this->add_control(
        'nav_move_count',
        [
            'label' => __('Nav Move Top', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -100,
            'max'     => 1,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => ['position_two' , 'position_three'],
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_two .owl-carousel .owl-nav , {{WRAPPER}}  .position_three .owl-carousel .owl-nav ' => 'top: {{VALUE}}px!important;',
            ],
        ]
    );
   
    $this->add_control(
        'nav_move_prev_left',
        [
            'label' => __('Prev Move Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => 'position_four',
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-prev   ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );
    $this->add_control(
        'nav_move_nest_right',
        [
            'label' => __('Prev Move Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'nav_style_options' => 'position_four',
            ],
            'selectors' => [
                '{{WRAPPER}}  .position_four .owl-carousel .owl-nav .owl-next   ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );


    $this->add_control(
        'owl_nav_color',
         [
            'label' => __('Owl Nav Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels  .owl-nav i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_bg_color',
         [
            'label' => __('Owl Nav Arrow Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-prev, .sec_category_carousels .owl-carousel .owl-nav .owl-next ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    
    $this->add_control(
        'owl_nav_hover_color',
         [
            'label' => __('Owl Nav Hover Arrow Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels  .owl-nav .owl-prev:hover i , {{WRAPPER}} .sec_category_carousels  .owl-nav .owl-next:hover i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
     
    $this->add_control(
        'owl_nav_hover_bg_color',
         [
            'label' => __('Owl Nav Hover Arrow Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-prev:hover , {{WRAPPER}} .sec_category_carousels .owl-carousel .owl-nav .owl-next:hover ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->end_controls_section();

    $this->start_controls_section('owl_dot_style',
    [ 
        'label' => __('Dots Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );
    $this->add_control(
        'dots_display',
        [
        'label' => __('Dots Enable / Disabel', 'vankine-addons'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            'dot_true' => __( 'Block', 'vankine-addons' ),
            'dot_false' => __( 'none', 'vankine-addons' ),
        ],
        'default' => 'dot_true' , 
       
        ]
    ); 
    $this->add_responsive_control(
        'dotalignment',
        [
            'label' => esc_html__( 'Alignment', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'default' => 'center',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    );
    $this->add_control(
        'dot_left',
        [
            'label' => __('Dot Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'left',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'left: {{VALUE}}px!important;',
            ],
        ]
    );

    $this->add_control(
        'dot_right',
        [
            'label' => __('Dot Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'min'     => -1000,
            'max'     => 1000,
            'step'    => 1,
            'default'    => 0,
            'condition' => [
                'dotalignment' => 'right',
            ],
            'selectors' => [
                '{{WRAPPER}}  .owl-carousel .owl-dots  ' => 'right: {{VALUE}}px!important;',
            ],
        ]
    );
    

    $this->add_control(
        'dot_color',
         [
            'label' => __('Dot One Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot span ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 
    $this->add_control(
        'dot_ac_color',
         [
            'label' => __('Dot One Active / Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover ' => 'border-color: {{VALUE}}!important;',
                '{{WRAPPER}} .owl-carousel .owl-dots .owl-dot:hover span , {{WRAPPER}} .owl-carousel .owl-dots .owl-dot.active span ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

    ?>
    <section class="testimonial_carousel  position-relative <?php echo esc_attr($settings['nav_style_options']); ?> <?php echo esc_attr($settings['nav_display']); ?> <?php echo esc_attr($settings['dots_display']); ?>">
    <div class="theme_carousel owl-theme owl-carousel" data-options='{"loop": true , "margin": <?php echo esc_attr($settings['item_margin']); ?>, "autoheight":true, "lazyload":true, "nav": true, "dots": true, "autoplay": false, "autoplayTimeout": 6000,  "smartSpeed": 300, "responsive":{ "0" :{ "items": "1" }, "320" :{ "items" : "1" }, "500" :{ "items" : "1" }, "768" :{ "items" : "<?php echo esc_attr($settings['mobile']); ?>" } , "992":{ "items" : "<?php echo esc_attr($settings['tablet']); ?>" }, "1200":{ "items" : "<?php echo esc_attr($settings['desktop']); ?>" }}}'>
            <?php if($settings['testi_style'] == 'style_one'): ?>
            <?php foreach($settings['testi_repeater'] as $test_block):?>
                <div class="testimonial_box type_one">
                    <svg class="svg1" width="631" height="475" viewBox="0 0 631 475" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M631 382.071L599.611 363.928L630.163 346.265L630.442 346.109V309.8L631 309.476L630.442 309.152V272.854L599.633 255.034L630.197 237.36L630.476 237.204V199.621L598.25 218.256L597.971 218.413V254.074L597.949 254.062V291.008L568.679 307.934C568.411 307.666 568.065 307.465 567.686 307.364V236.567L536.296 218.424V182.126L506.458 164.876C506.513 164.686 506.547 164.497 506.547 164.295C506.547 164.094 506.513 163.904 506.458 163.726L536.018 146.633L536.296 146.476V110.837L566.537 128.322V201.554L596.922 183.981C597.324 184.383 597.87 184.628 598.473 184.628C599.678 184.628 600.659 183.645 600.659 182.439C600.659 181.422 599.968 180.573 599.031 180.327V110.212L630.186 92.1914L630.465 92.0349V54.4523L599.031 72.6292V72.5957L567.083 91.063L535.136 72.5957V109.553L504.059 127.528L503.78 127.685V162.195C502.843 162.441 502.152 163.29 502.152 164.307C502.152 165.323 502.843 166.172 503.78 166.418V200.928L535.17 219.072V254.722L504.896 272.228V236.578L473.518 218.413V217.765L472.96 218.089L472.402 217.765V218.413L441.292 236.4L441.013 236.556V274.139L471.398 256.565C471.8 256.967 472.346 257.213 472.949 257.213C473.551 257.213 474.109 256.967 474.499 256.565L503.769 273.491V346.734L535.716 328.267L566.548 346.086L597.38 363.917L567.106 381.423L566.548 381.099V381.747L565.99 382.071L566.548 382.395V418.693L597.937 436.836V470.699C597 470.945 596.309 471.794 596.309 472.81C596.309 474.017 597.29 475 598.495 475C599.7 475 600.681 474.017 600.681 472.81C600.681 472.609 600.648 472.419 600.592 472.241L630.152 455.147L630.431 454.991V417.408L599.042 435.552V400.55L631 382.071ZM599.086 219.061L629.36 201.554V236.556L599.086 254.062V219.061ZM629.327 345.449L599.053 362.956V327.954L629.327 310.448V345.449ZM629.327 308.504L599.053 290.997V255.995L629.327 273.502V308.504ZM598.506 291.969L628.78 309.476L615.026 317.43L598.506 326.982L569.225 310.057C569.27 309.878 569.314 309.688 569.314 309.487C569.314 309.286 569.281 309.096 569.225 308.917L598.506 291.969ZM566.559 273.513V307.364C566.18 307.465 565.834 307.666 565.566 307.934L551.433 299.756L536.296 291.008V256.006L551.433 264.754L566.559 273.513ZM567.652 128.322L597.926 110.815V145.817L567.652 163.323V128.322ZM567.652 199.621V164.619L597.926 147.113V180.327C596.989 180.573 596.298 181.422 596.298 182.439C596.298 182.64 596.331 182.83 596.387 183.009L567.652 199.621ZM599.086 73.8916L629.36 56.3851V91.387L599.086 108.894V73.8916ZM597.915 109.53L567.641 127.037V92.0349L597.915 74.5284V109.53ZM536.263 74.5284L566.537 92.0349V127.037L536.296 109.553V108.894L536.274 108.905V74.5284H536.263ZM535.17 110.826V145.828L505.9 162.754C505.632 162.486 505.286 162.284 504.907 162.184V128.322L535.17 110.826ZM504.907 200.269V166.407C505.286 166.306 505.632 166.116 505.9 165.837L535.181 182.763V217.765L504.907 200.269ZM566.559 237.215V272.217L551.422 263.469L536.285 254.722V219.72L566.559 237.215ZM442.139 272.217V237.215L472.413 219.709V252.923C471.476 253.169 470.785 254.018 470.785 255.034C470.785 255.236 470.818 255.425 470.874 255.604L442.139 272.217ZM473.518 252.923V219.709L503.792 237.215V272.217L475.068 255.615C475.113 255.437 475.157 255.247 475.157 255.046C475.157 254.018 474.455 253.169 473.518 252.923ZM504.907 273.513L535.181 256.006V291.008L504.907 308.515V273.513ZM504.907 309.8L535.181 292.293V327.295L504.907 344.801V309.8ZM536.285 327.306V292.304L551.422 301.052L565.009 308.906C564.964 309.085 564.919 309.275 564.919 309.476C564.919 310.492 565.611 311.341 566.548 311.587V344.801L536.285 327.306ZM567.675 311.587C568.054 311.487 568.4 311.297 568.667 311.017L597.937 327.943V362.945L567.664 345.438V311.587H567.675ZM597.949 364.889L598.506 364.565L599.064 364.889L628.78 382.071L598.506 399.578L568.232 382.071L597.949 364.889ZM567.675 383.032L597.949 400.539V435.54L567.675 418.034V383.032ZM629.327 419.33V454.332L600.057 471.257C599.789 470.989 599.443 470.788 599.064 470.688V436.825L629.327 419.33ZM443.768 200.593C443.768 200.392 443.735 200.202 443.679 200.023L473.239 182.93L473.518 182.774V110.212L502.609 93.3868C503.011 93.9454 503.658 94.314 504.394 94.314C505.599 94.314 506.58 93.3309 506.58 92.1243C506.58 91.1077 505.889 90.2586 504.952 90.0128V54.4523L473.562 72.5957V36.9458L441.057 18.1545V55.7483L471.856 73.5564L441.571 91.0742L412.289 74.1486C412.334 73.9698 412.379 73.7799 412.379 73.5788C412.379 72.3722 411.397 71.3891 410.192 71.3891C408.988 71.3891 408.006 72.3722 408.006 73.5788C408.006 74.5955 408.698 75.4445 409.635 75.6903V108.905V145.85L378.803 163.681L348.529 146.174L379.082 128.512L379.361 128.355V92.0238L379.918 91.6998L379.361 91.3758V55.7371L410.471 37.7502L410.75 37.5938V0L378.524 18.6349L378.245 18.7913V54.4412L347.971 36.9346V36.2867L347.414 36.6106L315.467 18.1433V53.2904C315.087 53.391 314.741 53.5921 314.474 53.8602L285.204 36.9346V0.011172L253.814 18.1545V18.1433L221.588 36.7782L221.31 36.9346V72.5845L191.036 55.078V54.43L190.478 54.754L189.92 54.43V55.078L159.089 72.8973L127.141 54.43V91.387L96.901 108.882V73.2325L64.4073 54.4412L33.018 36.2867V73.2325L3.74798 90.1581C3.34641 89.7559 2.79983 89.5101 2.18632 89.5101C0.981615 89.5101 0 90.4932 0 91.6998C0 92.9064 0.981615 93.8895 2.18632 93.8895C2.79983 93.8895 3.34641 93.6437 3.73683 93.2415L33.018 110.178V147.124L65.2439 128.478L65.5228 128.322V92.6717L95.7967 110.178V147.113L126.182 129.539C126.45 129.807 126.796 130.009 127.175 130.109V164.619L159.68 183.411V147.113L191.069 165.256V127.674L160.237 109.854L190.5 92.3589L222.447 110.826V73.8804L252.721 56.3739V127.674L221.611 145.661L221.332 145.817V183.4L251.717 165.826C252.119 166.228 252.665 166.474 253.268 166.474C254.473 166.474 255.454 165.491 255.454 164.284C255.454 163.268 254.763 162.419 253.826 162.173V128.31L284.936 110.324L285.215 110.167V74.5284L315.489 92.0349V125.897C314.552 126.143 313.86 126.992 313.86 128.009C313.86 128.21 313.894 128.4 313.949 128.579L284.389 145.672L284.111 145.828V183.411L316.058 164.943L347.447 183.087L378.836 164.943L410.226 183.087L441.057 165.256V198.471C440.12 198.716 439.429 199.565 439.429 200.582C439.429 201.789 440.41 202.772 441.615 202.772C442.786 202.783 443.768 201.8 443.768 200.593ZM472.402 182.126L443.132 199.052C442.865 198.783 442.519 198.582 442.139 198.482V164.619L442.697 164.295L472.413 147.113V182.126H472.402ZM410.75 110.826L441.024 128.333V163.335L410.75 145.828V110.826ZM442.139 128.322L472.402 110.826V145.828L442.128 163.335V128.322H442.139ZM472.402 109.53L442.128 127.037V92.0349L472.402 74.5284V109.53ZM503.836 56.3851V90.0016C502.899 90.2474 502.208 91.0965 502.208 92.1132C502.208 92.1802 502.219 92.2472 502.23 92.3142L473.573 108.882V73.8916L503.836 56.3851ZM442.184 20.0873L472.458 37.5938V72.5957L442.184 55.0891V20.0873ZM410.75 75.6791C411.129 75.5786 411.475 75.3887 411.743 75.1094L441.013 92.0349V127.037L410.739 109.53V75.6791H410.75ZM347.425 109.206L317.151 91.6998L330.905 83.7453L347.425 74.1933L377.699 91.6998L363.945 99.6543L347.425 109.206ZM316.593 57.5246C316.972 57.4241 317.318 57.2342 317.586 56.9549L346.298 73.5564L316.582 90.739V57.5246H316.593ZM346.867 72.5845L318.144 55.9717C318.188 55.793 318.233 55.6031 318.233 55.402C318.233 55.2009 318.199 55.0109 318.144 54.8322L346.867 38.2194V72.5845ZM346.867 110.178V145.18L318.144 128.567C318.188 128.389 318.233 128.199 318.233 127.998C318.233 126.981 317.541 126.132 316.604 125.886V92.6717L346.867 110.178ZM316.593 130.12C316.972 130.02 317.318 129.819 317.586 129.551L346.298 146.152L316.582 163.335V130.12H316.593ZM378.245 127.674L347.971 145.18V110.178L378.245 92.6717V127.674ZM379.361 19.4393L409.635 1.93276V36.9346L379.361 54.4412V19.4393ZM378.245 55.7371V90.739L347.971 73.2325V38.2306L378.245 55.7371ZM346.309 37.2586L317.597 53.8602C317.329 53.5921 316.984 53.391 316.604 53.2904V20.0761L346.309 37.2586ZM284.099 1.94393V36.9458L253.826 54.4523V19.4505L284.099 1.94393ZM189.943 56.3739V91.3758L159.669 108.882V73.8804L189.943 56.3739ZM128.29 56.3739L158.564 73.8804V108.882L143.427 100.135L128.29 91.387V56.3739ZM158.553 145.18L143.416 136.432L129.83 128.579C129.874 128.4 129.919 128.21 129.919 128.009C129.919 126.992 129.227 126.143 128.29 125.897V92.6717L143.427 101.419L158.564 110.167V145.18H158.553ZM95.7856 108.882L65.5228 91.3758V56.3739L95.7967 73.8804V108.882H95.7856ZM34.1334 38.2306L64.4073 55.7371V90.739L34.1334 73.2325V38.2306ZM4.29457 91.13L33.5757 74.2044L63.8496 91.711L50.0958 99.6543L33.5757 109.206L4.29457 92.2807C4.33918 92.102 4.3838 91.912 4.3838 91.711C4.3838 91.5099 4.33918 91.3199 4.29457 91.13ZM64.4073 127.674L34.1334 145.18V110.178L64.4073 92.6717V127.674ZM96.901 145.18V110.178L127.175 92.6717V125.886C126.238 126.132 125.546 126.981 125.546 127.998C125.546 128.199 125.58 128.389 125.636 128.567L96.901 145.18ZM158.553 181.467L128.279 163.96V130.098C128.658 129.997 129.004 129.807 129.272 129.528L143.405 137.706L158.542 146.454V181.467H158.553ZM189.943 163.323L159.669 145.817V110.815L189.943 128.322V163.323ZM221.321 108.882L191.058 91.387V56.3739L221.332 73.8804V108.882H221.321ZM222.436 72.5957V37.5826L252.71 20.0761V55.078L222.436 72.5957ZM284.099 38.2418V73.2325L253.826 90.739V55.7371L284.099 38.2418ZM222.436 181.478V146.476L252.71 128.97V162.184C251.773 162.43 251.081 163.279 251.081 164.295C251.081 164.497 251.115 164.686 251.171 164.865L222.436 181.478ZM284.099 109.53L253.826 127.037V92.0349L284.099 74.5284V109.53ZM285.215 38.2306L313.938 54.8322C313.894 55.0109 313.849 55.2009 313.849 55.402C313.849 56.4186 314.541 57.2677 315.478 57.5135V90.7278L285.204 73.2213V38.2306H285.215ZM285.215 146.476L314.485 129.551C314.753 129.819 315.098 130.02 315.478 130.12V163.983L285.204 181.489V146.476H285.215ZM347.425 181.802L317.151 164.295L346.867 147.113L347.425 146.789L347.983 147.113L377.699 164.295L347.425 181.802ZM379.918 164.295L410.192 146.789L440.466 164.295L410.192 181.802L379.918 164.295Z" fill="white" fill-opacity="0.05"/>
                    </svg>
                    <div class="top_content">
                        <?php if($test_block['rating_enable'] == 'yes'): ?>
                            <p>
                                <?php if($test_block['rating_one'] == 'one'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                <?php elseif($test_block['rating_one'] == 'two'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                <?php elseif($test_block['rating_one'] == 'three'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                <?php elseif($test_block['rating_one'] == 'four'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i>
                                <?php elseif($test_block['rating_one'] == 'five'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i>
                                <?php else: ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i>
                                <?php endif; ?>
                            </p>
                            <?php endif; ?>
                            <?php if(!empty($test_block['comments'])): ?>
                            <div class="title_no_a_30 t_comment">
                                <sup>“</sup><?php echo wp_kses($test_block['comments'] , $allowed_tags); ?> <sub>“</sub>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="lower_content clearfix">
                        <?php if($test_block['image_enable'] == 'yes'): ?>
                            <div class="image_box">
                                <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="image" />
                                <svg width="86" height="88" viewBox="0 0 86 88" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M39.9434 87.5484C17.5317 86.8101 0.00666874 66.6886 0.800056 42.6058C1.59344 18.523 20.4048 -0.401485 42.8165 0.336847C65.2281 1.07518 85.8758 32.0772 85.0824 56.16C84.289 80.2429 62.355 88.2868 39.9434 87.5484Z" fill="var(--color-set-one-1)"/>
                                </svg>
                            </div>
                        <?php endif; ?>
                        <div class="cont">
                            <?php if(!empty($test_block['name'])): ?>
                                 <h4 class="title_no_a_22"><?php echo esc_attr($test_block['name']); ?></h4>
                            <?php endif; ?>
                            <?php if(!empty($test_block['designation'])): ?>
                                <p><?php echo esc_attr($test_block['designation']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <i class="flaticon-right-quote"></i>
            </div>
        <?php endforeach; ?>
        <?php elseif($settings['testi_style'] == 'style_two' || $settings['testi_style'] == 'style_three'): ?>
            <?php foreach($settings['testi_repeater'] as $test_block):?>
                <div class="testimonial_box type_two <?php if($settings['testi_style'] == 'style_three'): ?>type_three<?php endif; ?>">
                            <div class="auth d-flex align-items-center clearfix">
                                <?php if($test_block['image_enable'] == 'yes'): ?>
                                    <div class="image_box">
                                        <img src="<?php echo esc_url($test_block['image']['url']); ?>" alt="image" />
                                    </div>
                                <?php endif; ?>
                                <div class="cont">
                                    <?php if(!empty($test_block['name'])): ?>
                                        <h4 class="title_no_a_24"><?php echo esc_attr($test_block['name']); ?></h4>
                                    <?php endif; ?>
                                    <?php if(!empty($test_block['designation'])): ?>
                                        <p><?php echo esc_attr($test_block['designation']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                         
                            <?php if(!empty($test_block['comments'])): ?>
                            <div class="title_no_a_22 t_comment">
                                <sup>“</sup><?php echo wp_kses($test_block['comments'] , $allowed_tags); ?> <sub>“</sub>
                            </div>
                            <?php endif; ?>
                            <div class="box">
                            <?php if(!empty($test_block['content'])): ?>
                                <h6><?php echo wp_kses($test_block['content'] , $allowed_tags); ?> </h6>
                            <?php endif; ?>
                            <?php if($test_block['rating_enable'] == 'yes'): ?>
                            <p>
                                <?php if($test_block['rating_one'] == 'one'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                <?php elseif($test_block['rating_one'] == 'two'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                <?php elseif($test_block['rating_one'] == 'three'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i><i class="fa fa-star empty"></i>
                                <?php elseif($test_block['rating_one'] == 'four'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star empty"></i>
                                <?php elseif($test_block['rating_one'] == 'five'): ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i>
                                <?php else: ?>
                                    <i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i><i class="fa fa-star fill"></i>
                                <?php endif; ?>
                            </p>
                            <?php endif; ?>
                            </div>
                   
            </div>
        <?php endforeach; ?>
        <?php endif; ?>
    </div>
</section>
 
<?php
    }
}

         