<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Contact_box_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-contact-box-v1';
    }

    public function get_title()
    {
        return __('Contact Box V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('widget_contact_box_v1_settings',
        [ 
            'label' => __('Widget  Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'contact_type',
            [
                'label' => __('Contact Type', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'address_type' => __('Address', 'vankine-addons'),
                    'phone_type' => __('Phone', 'vankine-addons'),
                    'mail_type' => __('Mail', 'vankine-addons'),
                    'timing_type' => __('Timing', 'vankine-addons'),
                ],
                'default' => 'address_type',
            ]
        );
        $this->add_control(
            'icon_enable',
            [
                'label' => esc_html__( 'Icon Enable  / Disable', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        
        $this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'image' => esc_html__( 'Image', 'vankine-addons' ),
					'icon'  => esc_html__( 'Icon', 'vankine-addons' ), 
				], 
                'default' =>  'icon' ,  
			]
		);
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );
        $this->add_control(
            'switcher_c_icon',
            [
                'label' => esc_html__( 'Use Custom Icon', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'icon_type' => 'icon'
                ],
            ]
        );
        
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => vankine_get_icon(),
                'default' => 'fi-rs-user' , 
                'condition' => [
                    'switcher_c_icon' => 'yes' ,
                    'icon_type' => 'icon'
                ]
            ]
        );
        $this->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [
                    'switcher_c_icon' => '',
                    'icon_type' => 'icon'
                ]
            ]
        );
 
        
        $this->add_responsive_control(
          'address_title',
          [
             'label' => __('Address Title', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXT,
             'default' => __('Address', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),   
             'condition' => [
                'contact_type' => 'address_type'
            ], 
          ]
        );
        $this->add_responsive_control(
            'address',
            [
               'label' => __('Address', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('5171 W Campbell Ave undefined Kent, Utah 53127 United States', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),   
               'condition' => [
                  'contact_type' => 'address_type'
              ], 
            ]
        );
 
  
        $this->add_responsive_control(
          'phone_title',
          [
             'label' => __('Phone Title', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXT,
             'default' => __('Call Us', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),   
             'condition' => [
                'contact_type' => 'phone_type'
            ], 
          ]
        );
        $this->add_responsive_control(
            'phone',
            [
               'label' => __('Phone', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('(+91)-540-025-124553', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),   
               'condition' => [
                  'contact_type' => 'phone_type'
              ], 
            ]
        );
        $this->add_responsive_control(
            'phone_two',
            [
               'label' => __('Phone', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('(+91)-540-025-124553', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),   
               'condition' => [
                  'contact_type' => 'phone_type'
              ], 
            ]
        );

 
        $this->add_responsive_control(
          'email_title',
          [
             'label' => __('Mail Title', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXT,
             'default' => __('Email', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),   
             'condition' => [
                'contact_type' => 'mail_type'
            ], 
          ]
        );
        $this->add_responsive_control(
            'email',
            [
               'label' => __('Mail', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('sale@vankine.com', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),   
               'condition' => [
                  'contact_type' => 'mail_type'
              ], 
            ]
        );
        $this->add_responsive_control(
            'email_two',
            [
               'label' => __('Mail', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('sale@vankine.com', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),   
               'condition' => [
                  'contact_type' => 'mail_type'
              ], 
            ]
        );

         
        $this->add_responsive_control(
          'timing_title',
          [
             'label' => __('Timing Title', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXT,
             'default' => __('Hours', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),   
             'condition' => [
                'contact_type' => 'timing_type'
            ], 
          ]
        );
        $this->add_responsive_control(
            'timing',
            [
               'label' => __('Timing', 'vankine-addons'),
               'type' => \Elementor\Controls_Manager::TEXTAREA,
               'default' => __('10:00 - 18:00, Mon - Sat', 'vankine-addons'),
               'placeholder' => __('Type your text here', 'vankine-addons'),   
               'condition' => [
                  'contact_type' => 'timing_type'
              ], 
            ]
        );
 
    $this->end_controls_section();

    $this->start_controls_section('contact_css',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );

    $this->add_control(
        'box_bg',
         [
            'label' => __('Box Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'icon_color',
         [
            'label' => __('Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content .icon i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'iconbg_color',
         [
            'label' => __('Icon Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content .icon ' => 'background: {{VALUE}}!important;',
            ],
         ]
    );
 
    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content .title_no_a_24 ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    
    $this->add_control(
        'description_color',
         [
            'label' => __('Description Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .contact_box_content .contact-infor span , {{WRAPPER}} .contact_box_content .contact-infor  a  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

 
    $this->add_control(
        'border_radius',
        [
            'label' => esc_html__( 'Border Radius', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .newsletter .newsletter-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
  

    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); 
    ?>
 
 
    <div class="contact_box_content">
        <?php if($settings['icon_enable'] == 'yes'): ?>
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon trans">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                    <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <div class="icon trans">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                            </div>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon trans">
                                <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                        <?php endif; ?>	
                <?php endif; ?>	
            <?php endif; ?>
        <?php endif; ?>
        <?php if($settings['contact_type'] == 'address_type'): // Address ?>
             
            <div class="contact-infor">
            <?php if(!empty($settings['address_title'])): ?>
    
                <h6 class="title_no_a_24">   <?php echo wp_kses($settings['address_title'] , $allowed_tags); ?></h6>
            <?php endif; ?>
            <?php if(!empty($settings['address'])): ?>
                <span><?php echo wp_kses($settings['address'] , $allowed_tags); ?></span>
            <?php endif; ?>
        </div>
        <?php endif; // Address ?>
        <?php if($settings['contact_type'] == 'phone_type'): // phone ?>
            <div class="contact-infor">
            <?php if(!empty($settings['phone_title'])): ?>
              
                <h6 class="title_no_a_24"><?php echo wp_kses($settings['phone_title'] , $allowed_tags); ?></h6>
            <?php endif; ?>
            <?php if(!empty($settings['phone'])): ?>
                <a href="tel:<?php echo esc_attr($settings['phone']); ?>"><?php echo esc_attr($settings['phone']); ?></a>
            <?php endif; ?>
            <?php if(!empty($settings['phone_two'])): ?>
                <a href="tel:<?php echo esc_attr($settings['phone_two']); ?>"><?php echo esc_attr($settings['phone_two']); ?></a>
            <?php endif; ?>
        </div>
        <?php endif; // phone ?>
        <?php if($settings['contact_type'] == 'mail_type'): // mail ?>
            <div class="contact-infor">
            <?php if(!empty($settings['email_title'])): ?>
       
                <h6 class="title_no_a_24"><?php echo wp_kses($settings['email_title'] , $allowed_tags); ?></h6>
            
                <?php endif; ?>
            <?php if(!empty($settings['email'])): ?>
                <a href="mailto:<?php echo esc_attr($settings['email']); ?>"><?php echo esc_attr($settings['email']); ?></a>
            <?php endif; ?>
            <?php if(!empty($settings['email_two'])): ?>
                <a href="mailto:<?php echo esc_attr($settings['email_two']); ?>"><?php echo esc_attr($settings['email_two']); ?></a>
            <?php endif; ?>
        </div>
        <?php endif; // mail ?>
        <?php if($settings['contact_type'] == 'timing_type'): // timing ?>
            <div class="contact-infor">
            <?php if(!empty($settings['timing_title'])): ?>
            <h6 class="title_no_a_24"><?php echo wp_kses($settings['timing_title'] , $allowed_tags); ?></h6>
            <?php endif; ?>
            <?php if(!empty($settings['timing'])): ?>
                <span><?php echo wp_kses($settings['timing'] , $allowed_tags); ?></span>
            <?php endif; ?>
        </div>
        <?php endif; // timing ?>
        </div>
 
  
  

  
 


    <?php
    }
}
 

