<?php 
namespace Vankineaddons\Core;
class Functions{
	  /**
      * Instantiate the object.
      *
      * @since 1.0.0
      *
      * @return void
      */
      public function __construct() {
		add_shortcode('vankine-mega-menu', [$this, 'vankine_render_megamenu']);
		add_shortcode('vankine-header', [$this, 'vankine_render_header']);
		add_shortcode('vankine-footer', [$this, 'vankine_render_footer']);
	}
	/*
	** ============================== 
	**   vankineheader
	** ==============================
	*/ 
		
	public function vankine_render_header($atts, $content = '') {
		$query_args = array(
			'p' => $atts['id'],
			'post_type' => 'header',
		);
		$post_query = new \WP_Query($query_args); ?>

		<?php if ($post_query->have_posts()) : ?>
			<!-- the loop -->
			<?php while ($post_query->have_posts()) : $post_query->the_post(); ?>
				<?php the_content(); ?>
			<?php endwhile; ?>
			<!-- end of the loop -->

			<?php wp_reset_postdata(); ?>

		<?php else : ?>
			<p><?php esc_html__('Sorry, no posts matched your criteria.', 'vankine-addons'); ?></p>
		<?php endif;
	}
	/*
	** ============================== 
	**   vankine megamenu
	** ==============================
	*/ 
		
	public function vankine_render_megamenu($atts, $content = '') {
		$query_args = array(
			'p' => $atts['id'],
			'post_type' => 'mega_menu',
		);
		$post_query = new \WP_Query($query_args); ?>

		<?php if ($post_query->have_posts()) : ?>
			<!-- the loop -->
			<?php while ($post_query->have_posts()) : $post_query->the_post(); ?>
				<?php the_content(); ?>
			<?php endwhile; ?>
			<!-- end of the loop -->

			<?php wp_reset_postdata(); ?>

		<?php else : ?>
			<p><?php esc_html__('Sorry, no posts matched your criteria.', 'vankine-addons'); ?></p>
		<?php endif;
	}
	/*
	** ============================== 
	**   vankinefooter
	** ==============================
	*/ 
	public function vankine_render_footer($atts, $content = '') {
		$query_args = array(
			'p' => $atts['id'],
			'post_type' => 'footer',
		);
		$post_query = new \WP_Query($query_args); ?>

		<?php if ($post_query->have_posts()) : ?>
			<!-- the loop -->
			<?php while ($post_query->have_posts()) : $post_query->the_post(); ?>
				<?php the_content(); ?>
			<?php endwhile; ?>
			<!-- end of the loop -->

			<?php wp_reset_postdata(); ?>

		<?php else : ?>
			<p><?php esc_html__('Sorry, no posts matched your criteria.', 'vankine-addons'); ?></p>
		<?php endif;
	}	
}