#{{uc_id}}{
  min-height: 1px;
}

#{{uc_id}} .owl-item{
  transition: all 0.3s ease-in-out;
}

#{{uc_id}} .uc-active-item{
	z-index:2;
}

#{{uc_id}} *{
	box-sizing: border-box;
}

#{{uc_id}}  .uc_three_column_carousel_box{
	overflow: hidden;
	position: relative;
}

#{{uc_id}} .uc_image_box{
	position: relative;
	background-size: cover;
	background-repeat: no-repeat;
	background-position: center center;
	z-index: 1;
	position: relative;
	overflow: hidden;
	transform: scale(1, 1);
	-webkit-transform: scale(1, 1);	
	-webkit-backface-visibility: hidden;
    -webkit-transition: all .8s cubic-bezier(.2,.55,.1,.7);
    -moz-transition: all .8s cubic-bezier(.2,.55,.1,.7);
    transition: all .8s cubic-bezier(.2,.55,.1,.7);
}

#{{uc_id}} .uc_three_column_carousel_box:hover .uc_image_box{
	transform: scale(1.1, 1.1);
	-webkit-transform: scale(1.1, 1.1);
}

#{{uc_id}} .uc_box_content{
	position: absolute;
    {{overlay_position}}: 0;
    left: 0;
    right:0;
	z-index: 10;
	width: 100%;
	transition: all ease-in-out 0.3s;
}

.uc_title{
	font-size: 25px;
}

.uc_sub_title{
	font-size: 12px;
}

#{{uc_id}} .ue-content-bottom{
  margin-top:auto;
}

#{{uc_id}} .ue-btn-inner-wrapper{
  display:flex;
  align-items:center;
}

#{{uc_id}} .ue-btn-inner-wrapper svg{
  height:1em;
  width:1em;
}

#{{uc_id}}  .uc_more_btn {
	display:inline-block;
    transition: all 0.2s ease-in-out;
}

#{{uc_id}} .uc_overlay{
	position: absolute;
	left: 0;
	top: 0;
	width: 100%;
	height: 100%;
	z-index: 9;
	transition: all ease-in-out 0.3s;
	-webkit-transition: all ease-in-out 0.3s;
}

{% if make_content_visible_on_active == "true" %} 
  #{{uc_id}} .uc-active-item .uc_box_content{
    opacity: 1 !important;
  }
  #{{uc_id}} .uc-active-item .uc_overlay{
    opacity: 1 !important;
  }
{% endif %}	

#{{uc_id}} .owl-nav .owl-prev{
    position:absolute;
    left:{{nav_arrow_spacing}}px;
    display:inline-block;
    text-align:center;
    transform: translateY(-50%);
    transition:0.3s;
}

#{{uc_id}} .owl-nav .owl-next{
  position:absolute;
  right:{{nav_arrow_spacing}}px;
  display:inline-block;
  text-align:center;
  transform: translateY(-50%);
  transition:0.3s;
}

{% if show_on_hover == "true" %}
	#{{uc_id}} .owl-nav {
      opacity:0;
      transition:0.3s;
    }

    #{{uc_id}}:hover .owl-nav {
        opacity:1;
    } 
{% endif %}	

{% if make_3d == "true" %} 
#{{uc_id}} .owl-item {
	opacity: {{opacity_of_non_active}};
	transform: scale3d(0.8, 0.8, 1);
	transition: all 0.3s ease-in-out;
}

#{{uc_id}} .uc-active-item {
	opacity: 1;
	transform: scale3d(1, 1, 1);
	transition: all 0.3s ease-in-out;
}
{% endif %}

#{{uc_id}} .owl-dots {
  overflow:hidden;
}

#{{uc_id}} .owl-dot {
  display:inline-block;
  transition: all .3s;  
}

@media screen and (max-width: 780px) {
  #{{uc_id}} .owl-nav .owl-prev{
    left:{{nav_arrow_spacing_tablet}}px;
  }
  
  #{{uc_id}} .owl-nav .owl-next{
      right:{{nav_arrow_spacing_tablet}}px;
  }
}

@media screen and (max-width: 420px) {
  #{{uc_id}} .owl-nav .owl-prev{
    left:{{nav_arrow_spacing_mobile}}px;
  }
  
  #{{uc_id}} .owl-nav .owl-next{
      right:{{nav_arrow_spacing_mobile}}px;
  }
}